/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.lease;

import java.util.concurrent.TimeUnit;
import org.simpleframework.common.lease.Cleaner;
import org.simpleframework.common.lease.ContractController;
import org.simpleframework.common.lease.ContractLease;
import org.simpleframework.common.lease.ContractMaintainer;
import org.simpleframework.common.lease.Expiration;
import org.simpleframework.common.lease.Lease;
import org.simpleframework.common.lease.LeaseException;
import org.simpleframework.common.lease.LeaseProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeaseManager<T>
implements LeaseProvider<T> {
    private ContractController<T> handler;

    public LeaseManager(Cleaner<T> cleaner) {
        this.handler = new ContractMaintainer<T>(cleaner);
    }

    @Override
    public Lease<T> lease(T key, long duration, TimeUnit unit) {
        Expiration<T> contract = new Expiration<T>(key, duration, unit);
        try {
            this.handler.issue(contract);
        }
        catch (Exception e) {
            throw new LeaseException("Could not issue lease", e);
        }
        return new ContractLease<T>(this.handler, contract);
    }

    @Override
    public void close() {
        try {
            this.handler.close();
        }
        catch (Exception e) {
            return;
        }
    }
}

