/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.common.thread;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.simpleframework.common.thread.DaemonFactory;

class SchedulerQueue {
    private final ScheduledThreadPoolExecutor executor;
    private final ThreadFactory factory;

    public SchedulerQueue(Class type, int size) {
        this.factory = new DaemonFactory(type);
        this.executor = new ScheduledThreadPoolExecutor(size, this.factory);
    }

    public void execute(Runnable task) {
        this.executor.execute(task);
    }

    public void execute(Runnable task, long delay) {
        this.execute(task, delay, TimeUnit.MILLISECONDS);
    }

    public void execute(Runnable task, long delay, TimeUnit unit) {
        this.executor.schedule(task, delay, unit);
    }

    public void stop() {
        this.stop(60000L);
    }

    public void stop(long wait) {
        if (!this.executor.isTerminated()) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(wait, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not stop pool", e);
            }
        }
    }
}

