/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.simpleframework.common.thread.ConcurrentExecutor;
import org.simpleframework.common.thread.Daemon;
import org.simpleframework.transport.OperationFactory;
import org.simpleframework.transport.ServerCleaner;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.TransportProcessor;
import org.simpleframework.transport.reactor.ExecutorReactor;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;

public class TransportSocketProcessor
implements SocketProcessor {
    private final ConcurrentExecutor executor;
    private final OperationFactory factory;
    private final Reactor reactor;
    private final Daemon cleaner;

    public TransportSocketProcessor(TransportProcessor processor) throws IOException {
        this(processor, 8);
    }

    public TransportSocketProcessor(TransportProcessor processor, int threads) throws IOException {
        this(processor, threads, 4096);
    }

    public TransportSocketProcessor(TransportProcessor processor, int threads, int buffer) throws IOException {
        this(processor, threads, buffer, 20480);
    }

    public TransportSocketProcessor(TransportProcessor processor, int threads, int buffer, int threshold) throws IOException {
        this(processor, threads, buffer, threshold, false);
    }

    public TransportSocketProcessor(TransportProcessor processor, int threads, int buffer, int threshold, boolean client) throws IOException {
        this.executor = new ConcurrentExecutor(Operation.class, threads);
        this.reactor = new ExecutorReactor((Executor)this.executor);
        this.factory = new OperationFactory(processor, this.reactor, buffer, threshold, client);
        this.cleaner = new ServerCleaner(processor, this.executor, this.reactor);
    }

    public void process(Socket socket) throws IOException {
        Operation task = this.factory.getInstance(socket);
        if (task != null) {
            this.reactor.process(task);
        }
    }

    public void stop() throws IOException {
        this.cleaner.start();
        this.executor.stop();
    }
}

