/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.BodyConsumer;
import org.simpleframework.http.message.ByteConsumer;
import org.simpleframework.http.message.ContentConsumer;
import org.simpleframework.http.message.PartData;
import org.simpleframework.http.message.PartSeries;
import org.simpleframework.http.message.Segment;
import org.simpleframework.http.message.TokenConsumer;
import org.simpleframework.transport.ByteCursor;

class PartBodyConsumer
implements BodyConsumer {
    private static final byte[] LINE = new byte[]{13, 10};
    private ContentConsumer content;
    private ByteConsumer token;

    public PartBodyConsumer(Allocator allocator, Segment segment, byte[] boundary) {
        this(allocator, segment, new PartData(), boundary);
    }

    public PartBodyConsumer(Allocator allocator, Segment segment, PartSeries series, byte[] boundary) {
        this.content = new ContentConsumer(allocator, segment, series, boundary);
        this.token = new TokenConsumer(allocator, LINE);
    }

    public Body getBody() {
        return this.content.getBody();
    }

    public void consume(ByteCursor cursor) throws IOException {
        while (cursor.isReady()) {
            if (this.content.isFinished()) {
                if (this.token.isFinished()) break;
                this.token.consume(cursor);
                continue;
            }
            this.content.consume(cursor);
        }
    }

    public boolean isFinished() {
        return this.token.isFinished();
    }
}

