/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.parse;

import org.simpleframework.common.parse.ParseBuffer;
import org.simpleframework.common.parse.Parser;
import org.simpleframework.http.ContentDisposition;

public class ContentDispositionParser
extends Parser
implements ContentDisposition {
    private ParseBuffer skip;
    private ParseBuffer file = new ParseBuffer();
    private ParseBuffer name = new ParseBuffer();
    private boolean form;

    public ContentDispositionParser() {
        this.skip = new ParseBuffer();
    }

    public ContentDispositionParser(String text) {
        this();
        this.parse(text);
    }

    public String getFileName() {
        return this.file.toString();
    }

    public String getName() {
        return this.name.toString();
    }

    public boolean isFile() {
        return !this.form || this.file.length() > 0;
    }

    protected void init() {
        if (this.count > 0) {
            this.pack();
        }
        this.clear();
    }

    protected void clear() {
        this.file.clear();
        this.name.clear();
        this.form = false;
        this.off = 0;
    }

    protected void parse() {
        this.type();
        this.parameters();
    }

    private void pack() {
        char old = this.buf[0];
        int len = this.count;
        int seek = 0;
        int pos = 0;
        block0: while (seek < len) {
            char ch;
            if ((ch = this.buf[seek++]) == '\"' && old != '\\') {
                this.buf[pos++] = ch;
                while (seek < len) {
                    old = this.buf[seek - 1];
                    ch = this.buf[seek++];
                    this.buf[pos++] = ch;
                    if (ch != '\"' || old == '\\') continue;
                    continue block0;
                }
                continue;
            }
            if (this.space(ch)) continue;
            old = this.buf[seek - 1];
            this.buf[pos++] = old;
        }
        this.count = pos;
    }

    private void type() {
        if (this.skip("form-data")) {
            this.form = true;
        } else if (this.skip("file")) {
            this.form = false;
        }
    }

    private void parameters() {
        while (this.skip(";")) {
            if (this.skip("filename=")) {
                this.value(this.file);
                continue;
            }
            if (this.skip("name=")) {
                this.value(this.name);
                continue;
            }
            this.parameter();
        }
    }

    private void parameter() {
        this.name();
        ++this.off;
        this.value(this.skip);
    }

    private void name() {
        while (this.off < this.count && this.buf[this.off] != '=') {
            ++this.off;
        }
    }

    private void value(ParseBuffer value) {
        if (this.quote(this.buf[this.off])) {
            char quote = this.buf[this.off];
            ++this.off;
            while (this.off < this.count && (quote != this.buf[this.off] || this.buf[++this.off - 2] == '\\')) {
                value.append(this.buf[this.off++]);
            }
        } else {
            while (this.off < this.count && this.buf[this.off] != ';') {
                value.append(this.buf[this.off]);
                ++this.off;
            }
        }
    }

    private boolean quote(char ch) {
        return ch == '\'' || ch == '\"';
    }
}

