/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket;

import org.simpleframework.http.socket.BinaryData;
import org.simpleframework.http.socket.Data;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.FrameType;
import org.simpleframework.http.socket.TextData;

public class DataFrame
implements Frame {
    private final FrameType type;
    private final Data data;
    private final boolean last;

    public DataFrame(FrameType type) {
        this(type, new byte[0]);
    }

    public DataFrame(FrameType type, byte[] data) {
        this(type, data, true);
    }

    public DataFrame(FrameType type, byte[] data, boolean last) {
        this(type, new BinaryData(data), last);
    }

    public DataFrame(FrameType type, String text) {
        this(type, text, true);
    }

    public DataFrame(FrameType type, String text, boolean last) {
        this(type, new TextData(text), last);
    }

    public DataFrame(FrameType type, Data data) {
        this(type, data, true);
    }

    public DataFrame(FrameType type, Data data, boolean last) {
        this.data = data;
        this.type = type;
        this.last = last;
    }

    public boolean isFinal() {
        return this.last;
    }

    public byte[] getBinary() {
        return this.data.getBinary();
    }

    public String getText() {
        return this.data.getText();
    }

    public Frame getFrame(FrameType type) {
        return new DataFrame(type, this.data, this.last);
    }

    public FrameType getType() {
        return this.type;
    }

    public String toString() {
        return this.getText();
    }
}

