/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import java.io.IOException;
import org.simpleframework.http.Request;
import org.simpleframework.http.socket.CloseCode;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.FrameType;
import org.simpleframework.http.socket.Reason;
import org.simpleframework.http.socket.service.OutputBarrier;
import org.simpleframework.http.socket.service.ServiceEvent;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.trace.Trace;

class FrameEncoder {
    private final OutputBarrier barrier;
    private final Channel channel;
    private final Trace trace;
    private final String charset;

    public FrameEncoder(Request request) {
        this(request, "UTF-8");
    }

    public FrameEncoder(Request request, String charset) {
        this.barrier = new OutputBarrier(request, 5000L);
        this.channel = request.getChannel();
        this.trace = this.channel.getTrace();
        this.charset = charset;
    }

    public int encode(String text) throws IOException {
        byte[] data = text.getBytes(this.charset);
        return this.encode(FrameType.TEXT, data, true);
    }

    public int encode(byte[] data) throws IOException {
        return this.encode(FrameType.BINARY, data, true);
    }

    public int encode(Reason reason) throws IOException {
        CloseCode code = reason.getCode();
        String text = reason.getText();
        byte[] header = code.getData();
        if (text != null) {
            byte[] data = text.getBytes(this.charset);
            byte[] message = new byte[data.length + 2];
            message[0] = header[0];
            message[1] = header[1];
            for (int i = 0; i < data.length; ++i) {
                message[i + 2] = data[i];
            }
            return this.encode(FrameType.CLOSE, message, true);
        }
        return this.encode(FrameType.CLOSE, header, true);
    }

    public int encode(Frame frame) throws IOException {
        FrameType code = frame.getType();
        byte[] data = frame.getBinary();
        boolean last = frame.isFinal();
        return this.encode(code, data, last);
    }

    private int encode(FrameType type, byte[] data, boolean last) throws IOException {
        int i;
        byte[] header = new byte[10];
        long length = data.length;
        int count = 0;
        if (last) {
            header[0] = (byte)(header[0] | 0x80);
        }
        header[0] = (byte)(header[0] | type.code % 128);
        if (length <= 125L) {
            header[1] = (byte)length;
            count = 2;
        } else if (length >= 126L && length <= 65535L) {
            header[1] = 126;
            header[2] = (byte)(length >>> 8 & 0xFFL);
            header[3] = (byte)(length & 0xFFL);
            count = 4;
        } else {
            header[1] = 127;
            header[2] = (byte)(length >>> 56 & 0xFFL);
            header[3] = (byte)(length >>> 48 & 0xFFL);
            header[4] = (byte)(length >>> 40 & 0xFFL);
            header[5] = (byte)(length >>> 32 & 0xFFL);
            header[6] = (byte)(length >>> 24 & 0xFFL);
            header[7] = (byte)(length >>> 16 & 0xFFL);
            header[8] = (byte)(length >>> 8 & 0xFFL);
            header[9] = (byte)(length & 0xFFL);
            count = 10;
        }
        byte[] reply = new byte[count + data.length];
        for (i = 0; i < count; ++i) {
            reply[i] = header[i];
        }
        i = 0;
        while ((long)i < length) {
            reply[i + count] = data[i];
            ++i;
        }
        this.trace.trace((Object)ServiceEvent.WRITE_FRAME, (Object)type);
        this.barrier.send(reply);
        return reply.length;
    }
}

