/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket.service;

import org.simpleframework.http.socket.CloseCode;
import org.simpleframework.http.socket.DataConverter;
import org.simpleframework.http.socket.Frame;
import org.simpleframework.http.socket.Reason;

class ReasonExtractor {
    private final DataConverter converter = new DataConverter();

    public Reason extract(Frame frame) {
        byte[] data = frame.getBinary();
        if (data.length > 0) {
            CloseCode code = this.extractCode(data);
            String text = this.extractText(data);
            return new Reason(code, text);
        }
        return new Reason(CloseCode.NO_STATUS_CODE);
    }

    private String extractText(byte[] data) {
        int length = data.length - 2;
        if (length > 0) {
            return this.converter.convert(data, 2, length);
        }
        return null;
    }

    private CloseCode extractCode(byte[] data) {
        int length = data.length;
        if (length > 0) {
            byte high = data[0];
            byte low = data[1];
            return CloseCode.resolveCode(high, low);
        }
        return CloseCode.NO_STATUS_CODE;
    }
}

