/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector;

import org.apache.commons.lang3.StringUtils;

public class ProxyUtils {
    public static final String SCHEME_HTTPS = "https";
    public static final String SCHEME_HTTP = "http";
    public static final String PROPERTY_SUFFIX_PROXY_HOST = ".proxyHost";
    public static final String PROPERTY_SUFFIX_PROXY_PORT = ".proxyPort";
    public static final String PROPERTY_SUFFIX_PROXY_USERNAME = ".proxyUsername";
    public static final String PROPERTY_SUFFIX_PROXY_USER = ".proxyUser";
    public static final String PROPERTY_SUFFIX_PROXY_PASSWORD = ".proxyPassword";

    public static boolean isProxyUsed() {
        return StringUtils.isNotBlank(ProxyUtils.defineSchemeFromSystemProperties());
    }

    public static String getProxyHost() {
        String protocol = ProxyUtils.defineSchemeFromSystemProperties();
        return System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_HOST);
    }

    public static Integer getProxyPort() {
        String protocol = ProxyUtils.defineSchemeFromSystemProperties();
        if (StringUtils.isNotBlank(protocol)) {
            return Integer.valueOf(System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PORT));
        }
        return null;
    }

    public static String getProxyUser() {
        String protocol = ProxyUtils.defineSchemeFromSystemProperties();
        String username = System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_USERNAME);
        String user = System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_USER);
        return StringUtils.isNotBlank(username) ? username : user;
    }

    public static String getProxyPassword() {
        String protocol = ProxyUtils.defineSchemeFromSystemProperties();
        return System.getProperty(protocol + PROPERTY_SUFFIX_PROXY_PASSWORD);
    }

    private static String defineSchemeFromSystemProperties() {
        if (StringUtils.isNotBlank(System.getProperty("https.proxyHost")) && StringUtils.isNotBlank(System.getProperty("https.proxyPort"))) {
            return SCHEME_HTTPS;
        }
        if (StringUtils.isNotBlank(System.getProperty("http.proxyHost")) && StringUtils.isNotBlank(System.getProperty("http.proxyPort"))) {
            return SCHEME_HTTP;
        }
        return null;
    }
}

