/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector;

import com.smartling.repoconnector.ProxyUtils;
import com.smartling.repoconnector.services.event.HealthEvent;
import com.smartling.repoconnector.services.event.RepositoryHealthEvent;
import com.smartling.repoconnector.services.manager.BrokerManager;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class RepoConnector {
    private static Logger logger;
    private static final String APPLICATION_CONTEXT = "classpath:applicationContext.xml";
    private static final String CONFIGURATION_FILE_NAME = "repo-connector.conf";
    private static final String DEFAULT_CONFIGURATION_DIRECTORY = "cfg";
    private static final String DEFAULT_LOGS_DIRECTORY = "logs";
    private static final String DEFAULT_ACTIVEMQ_DIRECTORY = "activemq-data";
    private static final String DEFAULT_DB_DIRECTORY = "db-data";
    private static final String PROPERTIES_FILE = "project.properties";
    private static final Options OPTIONS;

    public static void main(String[] args) {
        RepoConnector.configureProxyAuth();
        boolean done = false;
        try {
            BasicParser parser = new BasicParser();
            CommandLine line = parser.parse(OPTIONS, args);
            String configDir = DEFAULT_CONFIGURATION_DIRECTORY;
            if (line.hasOption("configuration")) {
                configDir = line.getOptionValue("configuration");
            }
            System.setProperty("configurationDirectory", configDir);
            Config configuration = RepoConnector.loadConfig(configDir).resolve();
            RepoConnector.configLogger(configuration, configDir);
            logger.info("Repo connector version is {}", (Object)RepoConnector.getVersion());
            logger.debug("Run commandline {}", (Object)Arrays.toString(args));
            logger.info("Configuration is {}", (Object)configDir);
            if (line.hasOption("start")) {
                RepoConnector.start(configuration);
                done = true;
            }
            if (line.hasOption("stop")) {
                RepoConnector.stop(configuration);
                done = true;
            }
            RepoConnector.addShutdownHook(configuration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!done) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("repo-connector", OPTIONS);
        }
    }

    private static void configureProxyAuth() {
        if (ProxyUtils.isProxyUsed()) {
            final String proxyUser = ProxyUtils.getProxyUser();
            final String proxyPassword = ProxyUtils.getProxyPassword();
            if (StringUtils.isNotEmpty(proxyPassword) && StringUtils.isNotEmpty(proxyUser)) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
            }
        }
    }

    private static void addShutdownHook(final Config configuration) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    RepoConnector.stop(configuration);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static String getVersion() throws IOException {
        String version = "version";
        Properties properties = new Properties();
        properties.load(RepoConnector.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE));
        return properties.getProperty(version);
    }

    private static void stop(Config configuration) throws Exception {
        Socket socket = null;
        try {
            socket = new Socket(configuration.getString("manager.manageHost"), configuration.getInt("manager.managePort"));
            IOUtils.write("exit", socket.getOutputStream());
            logger.info("Repository Connector Stopped");
        }
        catch (ConnectException e) {
            logger.warn("Repository Connector Stopped", (Throwable)e);
        }
        finally {
            if (null != socket) {
                socket.close();
            }
        }
    }

    private static void start(Config configuration) throws Exception {
        if (!RepoConnector.checkSocket(configuration)) {
            GenericApplicationContext staticContext = new GenericApplicationContext();
            Properties properties = new Properties();
            for (Map.Entry keyValue : configuration.entrySet()) {
                properties.put(keyValue.getKey(), ((ConfigValue)keyValue.getValue()).unwrapped().toString());
            }
            RepoConnector.populateSysPathProperty("queue_directory", "sys_queue_directory", DEFAULT_ACTIVEMQ_DIRECTORY, configuration, properties);
            RepoConnector.populateSysPathProperty("db_directory", "sys_db_directory", DEFAULT_DB_DIRECTORY, configuration, properties);
            RepositoryStateListener stateListener = new RepositoryStateListener();
            staticContext.getBeanFactory().registerSingleton("externalProperties", (Object)properties);
            staticContext.getBeanFactory().registerSingleton("externalConfiguration", (Object)configuration);
            staticContext.getBeanFactory().registerSingleton("externalRepositoryListener", (Object)stateListener);
            staticContext.refresh();
            FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(new String[]{APPLICATION_CONTEXT}, (ApplicationContext)staticContext);
            BrokerManager manager = (BrokerManager)context.getBean(BrokerManager.class);
            manager.start();
            logger.info("Repository Connector is starting");
            logger.info("Checking health...");
            manager.validateStartup();
            if (!stateListener.isWorking() || 0 == stateListener.getRepositoriesCount()) {
                manager.stop();
                logger.error("Repository Connector isn't started properly. Stopped");
            } else {
                logger.info("The health is OK");
                manager.schedule();
                logger.info("Periodical tasks are scheduled");
            }
        } else {
            logger.warn("Repository Connector is already started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkSocket(Config configuration) throws IOException {
        Socket socket = null;
        boolean isOpened = true;
        try {
            socket = new Socket(configuration.getString("manager.manageHost"), configuration.getInt("manager.managePort"));
        }
        catch (ConnectException e) {
            isOpened = false;
        }
        finally {
            if (null != socket) {
                socket.close();
            }
        }
        return isOpened;
    }

    private static Config loadConfig(String configDir) {
        Config system = ConfigFactory.load();
        Config local = ConfigFactory.parseFile((File)new File(configDir, CONFIGURATION_FILE_NAME));
        return local.withFallback((ConfigMergeable)system);
    }

    private static void configLogger(Config configuration, String configDir) {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
        java.util.logging.Logger.getLogger("global").setLevel(Level.FINEST);
        String logsDirectory = null;
        if (configuration.hasPath("logs_directory")) {
            logsDirectory = configuration.getString("logs_directory");
        }
        if (StringUtils.isBlank(logsDirectory)) {
            logsDirectory = FilenameUtils.concat(configDir, DEFAULT_LOGS_DIRECTORY);
        }
        System.setProperty("logback.configurationFile", FilenameUtils.concat(configDir, "logback.xml"));
        System.setProperty("logback_logs_path", logsDirectory);
        logger = LoggerFactory.getLogger(RepoConnector.class);
    }

    private static void populateSysPathProperty(String propName, String sysPropName, String defaultValue, Config configuration, Properties properties) {
        String propValue = null;
        if (configuration.hasPath(propName)) {
            propValue = configuration.getString(propName);
        }
        if (StringUtils.isBlank(propValue)) {
            propValue = FilenameUtils.concat(configuration.getString("configurationDirectory"), defaultValue);
        }
        properties.put(sysPropName, propValue);
    }

    static {
        OPTIONS = new Options();
        OPTIONS.addOption("help", false, "print help message");
        OPTIONS.addOption("start", false, "start github listening");
        OPTIONS.addOption("stop", false, "stop github listening");
        OptionBuilder.withDescription((String)"define configuration directory, default configuration directory is cfg");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dir");
        OPTIONS.addOption(OptionBuilder.create((String)"configuration"));
    }

    private static class RepositoryStateListener
    implements ApplicationListener<HealthEvent> {
        private int repositoriesCount = 0;
        private boolean working = true;

        private RepositoryStateListener() {
        }

        public void onApplicationEvent(HealthEvent event) {
            if (event.isOk()) {
                if (event instanceof RepositoryHealthEvent) {
                    ++this.repositoriesCount;
                }
                logger.info(event.toString());
            } else if (!(event instanceof RepositoryHealthEvent)) {
                this.working = false;
                logger.error(event.toString());
            } else {
                logger.warn(event.toString());
            }
        }

        public int getRepositoriesCount() {
            return this.repositoriesCount;
        }

        public boolean isWorking() {
            return this.working;
        }
    }
}

