/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.model;

import com.smartling.repoconnector.model.ImportStatus;
import com.smartling.repoconnector.model.ResourceData;
import com.smartling.repoconnector.model.ResourceStatus;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ImportResult {
    private ImportStatus importStatus;
    private List<String> errors;
    private ResourceData resourceData;
    private Collection<String> localeIds;
    private ResourceStatus resourceStatus;

    public ImportResult(ImportStatus importStatus, ResourceData resourceData, Collection<String> localeIds, ResourceStatus status) {
        this.importStatus = importStatus;
        this.resourceData = resourceData;
        this.localeIds = localeIds;
        this.resourceStatus = status;
    }

    public ImportResult(ImportStatus importStatus, ResourceData resourceData, Collection<String> localeIds, ResourceStatus status, List<String> errors) {
        this.importStatus = importStatus;
        this.resourceData = resourceData;
        this.localeIds = localeIds;
        this.resourceStatus = status;
        this.errors = errors;
    }

    public ImportStatus getImportStatus() {
        return this.importStatus;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public ResourceData getResourceData() {
        return this.resourceData;
    }

    public Collection<String> getLocaleIds() {
        return this.localeIds;
    }

    public ResourceStatus getResourceStatus() {
        return this.resourceStatus;
    }

    public String toString() {
        return new ToStringBuilder(this).append((Object)this.importStatus).append(this.resourceData.getSmartlingUri()).append(this.resourceData.getProjectId()).append(this.localeIds).append((Object)this.resourceStatus).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportResult that = (ImportResult)o;
        return this.importStatus == that.importStatus && Objects.equals(this.errors, that.errors) && Objects.equals(this.resourceData, that.resourceData) && Objects.equals(this.localeIds, that.localeIds) && this.resourceStatus == that.resourceStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.importStatus, this.errors, this.resourceData, this.localeIds, this.resourceStatus});
    }
}

