/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.model;

import com.smartling.api.files.v2.pto.RetrievalType;
import com.smartling.repoconnector.model.RetrievalTriggerType;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ProjectData {
    private String alias;
    private String projectId;
    private String branch;
    private String serverResourcesConfig;
    private String resourcesConfig;
    private String pollingSchedule;
    private String cleanBranchesSchedule;
    private boolean namespace = false;
    private boolean includeOriginalStrings = false;
    private RetrievalTriggerType retrievalTriggerType = RetrievalTriggerType.COMPLETED;
    private RetrievalType retrievalType = RetrievalType.PUBLISHED;
    private String outdatedBranchesDays;
    private String trunkFolder;
    private String branchesFolder;
    private String postCheckOutHook;
    private String preCommitHook;
    private boolean cloneSingleBranch = false;

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getServerResourcesConfig() {
        return this.serverResourcesConfig;
    }

    public void setServerResourcesConfig(String serverResourcesConfig) {
        this.serverResourcesConfig = serverResourcesConfig;
    }

    public String getResourcesConfig() {
        return this.resourcesConfig;
    }

    public void setResourcesConfig(String resourcesConfig) {
        this.resourcesConfig = resourcesConfig;
    }

    public String getPollingSchedule() {
        return this.pollingSchedule;
    }

    public void setPollingSchedule(String pollingSchedule) {
        this.pollingSchedule = pollingSchedule;
    }

    public String getCleanBranchesSchedule() {
        return this.cleanBranchesSchedule;
    }

    public void setCleanBranchesSchedule(String cleanBranchesSchedule) {
        this.cleanBranchesSchedule = cleanBranchesSchedule;
    }

    public boolean isNamespace() {
        return this.namespace;
    }

    public void setNamespace(boolean namespace) {
        this.namespace = namespace;
    }

    public boolean isIncludeOriginalStrings() {
        return this.includeOriginalStrings;
    }

    public void setIncludeOriginalStrings(boolean includeOriginalStrings) {
        this.includeOriginalStrings = includeOriginalStrings;
    }

    public RetrievalTriggerType getRetrievalTriggerType() {
        return this.retrievalTriggerType;
    }

    public void setRetrievalTriggerType(RetrievalTriggerType retrievalTriggerType) {
        this.retrievalTriggerType = retrievalTriggerType;
    }

    public RetrievalType getRetrievalType() {
        return this.retrievalType;
    }

    public void setRetrievalType(RetrievalType retrievalType) {
        this.retrievalType = retrievalType;
    }

    public String getTrunkFolder() {
        return this.trunkFolder;
    }

    public void setTrunkFolder(String trunkFolder) {
        this.trunkFolder = trunkFolder;
    }

    public String getBranchesFolder() {
        return this.branchesFolder;
    }

    public void setBranchesFolder(String branchesFolder) {
        this.branchesFolder = branchesFolder;
    }

    public boolean isBranchSuitable(String branchName) {
        return StringUtils.isEmpty(this.branch) || branchName.matches(this.branch);
    }

    public String getOutdatedBranchesDays() {
        return this.outdatedBranchesDays;
    }

    public void setOutdatedBranchesDays(String outdatedBranchesDays) {
        this.outdatedBranchesDays = outdatedBranchesDays;
    }

    public void setPostCheckOutHook(String postCheckOutHook) {
        this.postCheckOutHook = postCheckOutHook;
    }

    public String getPostCheckOutHook() {
        return this.postCheckOutHook;
    }

    public void setPreCommitHook(String preCommitHook) {
        this.preCommitHook = preCommitHook;
    }

    public String getPreCommitHook() {
        return this.preCommitHook;
    }

    public boolean isCloneSingleBranch() {
        return this.cloneSingleBranch;
    }

    public void setCloneSingleBranch(boolean cloneSingleBranch) {
        this.cloneSingleBranch = cloneSingleBranch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectData that = (ProjectData)o;
        return this.namespace == that.namespace && this.includeOriginalStrings == that.includeOriginalStrings && this.cloneSingleBranch == that.cloneSingleBranch && Objects.equals(this.alias, that.alias) && Objects.equals(this.projectId, that.projectId) && Objects.equals(this.branch, that.branch) && Objects.equals(this.serverResourcesConfig, that.serverResourcesConfig) && Objects.equals(this.resourcesConfig, that.resourcesConfig) && Objects.equals(this.pollingSchedule, that.pollingSchedule) && Objects.equals(this.cleanBranchesSchedule, that.cleanBranchesSchedule) && this.retrievalTriggerType == that.retrievalTriggerType && this.retrievalType == that.retrievalType && Objects.equals(this.outdatedBranchesDays, that.outdatedBranchesDays) && Objects.equals(this.trunkFolder, that.trunkFolder) && Objects.equals(this.branchesFolder, that.branchesFolder) && Objects.equals(this.postCheckOutHook, that.postCheckOutHook) && Objects.equals(this.preCommitHook, that.preCommitHook);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alias, this.projectId, this.branch, this.serverResourcesConfig, this.resourcesConfig, this.pollingSchedule, this.cleanBranchesSchedule, this.namespace, this.includeOriginalStrings, this.retrievalTriggerType, this.retrievalType, this.outdatedBranchesDays, this.trunkFolder, this.branchesFolder, this.postCheckOutHook, this.preCommitHook, this.cloneSingleBranch});
    }
}

