/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.model;

import com.smartling.repoconnector.model.ChangeType;
import java.util.Objects;

public class RepositoryResourceChange {
    private ChangeType type;
    private String oldPath;
    private String newPath;

    public RepositoryResourceChange(ChangeType type, String oldPath, String newPath) {
        this.type = type;
        this.oldPath = oldPath;
        this.newPath = newPath;
    }

    public ChangeType getType() {
        return this.type;
    }

    public void setType(ChangeType type) {
        this.type = type;
    }

    public String getOldPath() {
        return this.oldPath;
    }

    public void setOldPath(String oldPath) {
        this.oldPath = oldPath;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public void setNewPath(String newPath) {
        this.newPath = newPath;
    }

    public String getActualPath() {
        String path = null;
        if (!ChangeType.DELETE.equals((Object)this.type)) {
            path = this.newPath;
        }
        return path;
    }

    public String getPreviousPath() {
        String path = null;
        if (!ChangeType.ADD.equals((Object)this.type)) {
            path = this.oldPath;
        }
        return path;
    }

    public String toString() {
        return "RepositoryResourceChange{type=" + this.type + ", oldPath='" + this.oldPath + "', newPath='" + this.newPath + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryResourceChange that = (RepositoryResourceChange)o;
        return this.type == that.type && Objects.equals(this.oldPath, that.oldPath) && Objects.equals(this.newPath, that.newPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.oldPath, this.newPath});
    }
}

