/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.model;

import com.smartling.api.files.v2.pto.FileType;
import com.smartling.repoconnector.model.ChangeType;
import com.smartling.repoconnector.model.ProjectData;
import com.smartling.repoconnector.model.PushImportRequest;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryResourceChange;
import com.smartling.repoconnector.model.RepositoryResourcesSet;
import com.smartling.repoconnector.model.ResourcePersistentData;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;

public class SmartlingResourceUpdate
implements ResourcePersistentData {
    private static final long serialVersionUID = 903497286050801274L;
    private PushImportRequest request;
    private RepositoryResourceChange resourceChange;
    private RepositoryResourcesSet resourcesSet;
    private ProjectData projectData;
    private String smartlingUri;
    private String previousSmartlingUri;
    private Date lastModified = null;

    public SmartlingResourceUpdate(PushImportRequest request, RepositoryResourceChange resourceChange, RepositoryResourcesSet resourcesSet, ProjectData projectData) {
        this.request = request;
        this.resourceChange = resourceChange;
        this.resourcesSet = resourcesSet;
        this.projectData = projectData;
    }

    public ChangeType getChangeType() {
        return this.resourceChange.getType();
    }

    public FileType getResourceType() {
        return this.resourcesSet.getType();
    }

    public String getResourceCallBackUrl() {
        return this.resourcesSet.getCallbackUrl();
    }

    public Boolean getAuthorizeContent() {
        return this.resourcesSet.getAuthorizeContent();
    }

    @Override
    public String getRepositoryPath() {
        return this.resourceChange.getActualPath();
    }

    public String getPreviousRepositoryPath() {
        return this.resourceChange.getPreviousPath();
    }

    @Override
    public String getProjectId() {
        return this.projectData.getProjectId();
    }

    public String getRepositoryAlias() {
        return this.projectData.getAlias();
    }

    public String getRepositoryBranch() {
        return this.request.getRepositoryKey().getBranch();
    }

    public String getRepositoryPrefix() {
        return FilenameUtils.normalize(FilenameUtils.concat(this.projectData.getAlias(), this.request.getRepositoryKey().getBranch()), true);
    }

    @Override
    public RepositoryKey getRepositoryKey() {
        return this.request.getRepositoryKey();
    }

    @Override
    public String getPathRegex() {
        return this.resourcesSet.getPathRegex();
    }

    @Override
    public String getPathExpression() {
        return this.resourcesSet.getPathExpression();
    }

    @Override
    public String getCommitMessage() {
        return this.resourcesSet.getCommitMessage();
    }

    @Override
    public Map<String, String> getLocalesMapping() {
        return Collections.unmodifiableMap(this.resourcesSet.getLocalesMapping());
    }

    public Boolean getNamespace() {
        return this.projectData.isNamespace();
    }

    @Override
    public String getSmartlingUri() {
        return this.smartlingUri;
    }

    public String getPreviousSmartlingUri() {
        return this.previousSmartlingUri;
    }

    public void setSmartlingUri(String previousSmartlingUri, String smartlingUri) {
        this.previousSmartlingUri = previousSmartlingUri;
        this.smartlingUri = smartlingUri;
    }

    public Map<String, String> getDirectives() {
        Map<String, String> directives = this.resourcesSet.getAdditionalDirectives();
        return null == directives ? null : Collections.unmodifiableMap(directives);
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(Date date) {
        this.lastModified = date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmartlingResourceUpdate that = (SmartlingResourceUpdate)o;
        return Objects.equals(this.request, that.request) && Objects.equals(this.resourceChange, that.resourceChange) && Objects.equals(this.resourcesSet, that.resourcesSet) && Objects.equals(this.projectData, that.projectData) && Objects.equals(this.smartlingUri, that.smartlingUri) && Objects.equals(this.previousSmartlingUri, that.previousSmartlingUri) && Objects.equals(this.lastModified, that.lastModified);
    }

    public int hashCode() {
        return Objects.hash(this.request, this.resourceChange, this.resourcesSet, this.projectData, this.smartlingUri, this.previousSmartlingUri, this.lastModified);
    }
}

