/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.model;

import com.smartling.repoconnector.model.ImportRequest;
import com.smartling.repoconnector.model.ImportType;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.ResourcePersistentData;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class TranslationImportRequest
implements ImportRequest {
    private static final long serialVersionUID = 6135134394719258184L;
    private ResourcePersistentData resourceData;
    private Collection<String> locales;
    private boolean force = false;

    public TranslationImportRequest(ResourcePersistentData resourceData, Collection<String> locales, boolean force) {
        this.resourceData = resourceData;
        this.locales = locales;
        this.force = force;
    }

    public TranslationImportRequest(ResourcePersistentData resourceData, Collection<String> locales) {
        this(resourceData, locales, false);
    }

    public ResourcePersistentData getResourceData() {
        return this.resourceData;
    }

    public String getSmartlingUri() {
        return this.resourceData.getSmartlingUri();
    }

    public Collection<String> getLocales() {
        return this.locales;
    }

    public boolean isForce() {
        return this.force;
    }

    @Override
    public RepositoryKey getRepositoryKey() {
        return this.resourceData.getRepositoryKey();
    }

    @Override
    public String getProjectId() {
        return this.resourceData.getProjectId();
    }

    @Override
    public ImportType getImportType() {
        return ImportType.SMARTLING2VCS;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslationImportRequest that = (TranslationImportRequest)o;
        return this.force == that.force && Objects.equals(this.resourceData, that.resourceData) && Objects.equals(this.locales, that.locales);
    }

    public int hashCode() {
        return Objects.hash(this.resourceData, this.locales, this.force);
    }
}

