/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.model;

import com.smartling.api.files.v2.pto.RetrievalType;
import com.smartling.repoconnector.model.ProjectData;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.ResourcePersistentData;
import com.smartling.repoconnector.model.RetrievalTriggerType;
import com.smartling.repoconnector.model.TranslationImportRequest;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class VcsResourceUpdate {
    private TranslationImportRequest translationImportRequest;
    private ProjectData projectData;

    public VcsResourceUpdate(TranslationImportRequest translationImportRequest, ProjectData projectData) {
        this.translationImportRequest = translationImportRequest;
        this.projectData = projectData;
    }

    public Date getLastModified() {
        return this.translationImportRequest.getResourceData().getLastModified();
    }

    public ResourcePersistentData getResourcePersistentData() {
        return this.translationImportRequest.getResourceData();
    }

    public RetrievalTriggerType getRetrievalTriggerType() {
        return this.projectData.getRetrievalTriggerType();
    }

    public RetrievalType getRetrievalType() {
        return this.projectData.getRetrievalType();
    }

    public boolean isIncludeOriginalStrings() {
        return this.projectData.isIncludeOriginalStrings();
    }

    public boolean isForce() {
        return this.translationImportRequest.isForce();
    }

    public Collection<String> getLocales() {
        return this.translationImportRequest.getLocales();
    }

    public RepositoryKey getRepositoryKey() {
        return this.translationImportRequest.getRepositoryKey();
    }

    public String getProjectId() {
        return this.translationImportRequest.getProjectId();
    }

    public String getSmartlingUri() {
        return this.translationImportRequest.getSmartlingUri();
    }

    public ProjectData getProjectData() {
        return this.projectData;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsResourceUpdate that = (VcsResourceUpdate)o;
        return Objects.equals(this.translationImportRequest, that.translationImportRequest) && Objects.equals(this.projectData, that.projectData);
    }

    public int hashCode() {
        return Objects.hash(this.translationImportRequest, this.projectData);
    }

    public TranslationImportRequest getTranslationImportRequest() {
        return this.translationImportRequest;
    }
}

