/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services;

import com.codahale.metrics.MetricRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public abstract class AbstractService {
    @Autowired
    private MetricRegistry metricRegistry;
    @Value(value="${configurationDirectory}")
    private String configurationDir;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private ApplicationContext applicationContext;

    protected String getConfigurationDirectory() {
        return this.configurationDir;
    }

    protected MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    protected void fireEvent(ApplicationEvent event) {
        this.eventPublisher.publishEvent(event);
    }

    protected <T> T getBean(Class<T> type, Object ... parameters) {
        String[] beanNames = this.applicationContext.getBeanNamesForType(type);
        if (null == beanNames || 1 != beanNames.length) {
            throw new RuntimeException("Configuration error! There are several implemenations for " + type);
        }
        return this.getBean(beanNames[0], parameters);
    }

    protected <T> T getBean(String name, Object ... parameters) {
        if (null == parameters || 0 == parameters.length) {
            return (T)this.applicationContext.getBean(name);
        }
        return (T)this.applicationContext.getBean(name, parameters);
    }
}

