/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.beanstalkapp;

import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.event.PushRequestVoteEvent;
import com.smartling.repoconnector.services.vcs.RepositoryFactory;
import com.typesafe.config.Config;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;

public abstract class AbstractAuthRequestVoteEventProcessor
implements ApplicationListener<PushRequestVoteEvent> {
    public static final String REPOSITORY_TYPE_CONFIG_PATH = "type";
    public static final String REPOSITORY_URL_CONFIG_PATH = "url";
    public static final String PROJECT_CONFIG_PATH = "smartlingProject";
    @Autowired
    private RepositoryFactory repositoryFactory;
    @Autowired
    private Config configuration;

    public void onApplicationEvent(PushRequestVoteEvent pushRequestVoteEvent) {
        if (this.isSupported(pushRequestVoteEvent)) {
            this.validate(pushRequestVoteEvent);
        }
    }

    private void validate(PushRequestVoteEvent pushRequestVoteEvent) {
        List repositoriesConfig = this.configuration.getConfigList("repositories");
        for (Config repositoryConfig : repositoriesConfig) {
            RepositoryType type = RepositoryType.valueOf(repositoryConfig.getString(REPOSITORY_TYPE_CONFIG_PATH));
            RepositoryKey repositoryKey = this.repositoryFactory.getKeyFromUrl(type, repositoryConfig.getString(REPOSITORY_URL_CONFIG_PATH), null);
            if (!repositoryKey.equals(pushRequestVoteEvent.getPushData().getRepositoryKey())) continue;
            pushRequestVoteEvent.vote(this.isVote(pushRequestVoteEvent, repositoryConfig));
        }
    }

    protected abstract boolean isVote(PushRequestVoteEvent var1, Config var2);

    protected abstract boolean isSupported(PushRequestVoteEvent var1);
}

