/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.beanstalkapp;

import com.smartling.repoconnector.model.HttpRequestData;
import com.smartling.repoconnector.model.PushImportRequest;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.http.converter.AbstractPushConverter;
import com.smartling.repoconnector.services.http.converter.ConverterException;
import com.smartling.repoconnector.services.http.converter.UnsupportedConverterException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class BeanstalkappPushConverter
extends AbstractPushConverter {
    private static final String BRANCH_ATTRIBUTE = "branch";
    private static final String PAYLOAD = "payload";
    private static final String COMMITS = "commits";
    private static final String CHANGESET_URL = "changeset_url";

    @Override
    public PushImportRequest convert(HttpRequestData request) throws ConverterException {
        if ("beanstalkapp".equals(request.getContext()) && request.getBody() != null) {
            try {
                JSONObject body = new JSONObject(request.getBody());
                String payload = body.getString(PAYLOAD);
                if (null == payload) {
                    throw new UnsupportedConverterException(request, this);
                }
                JSONObject payloadData = new JSONObject(payload);
                JSONArray commits = payloadData.getJSONArray(COMMITS);
                JSONObject commit = commits.getJSONObject(0);
                String url = this.convertChangesetUrlIntoRepoUrl(commit);
                RepositoryKey repositoryKey = this.getRepositoryKey(RepositoryType.GIT, url, payloadData.getString(BRANCH_ATTRIBUTE));
                PushImportRequest push = this.getPushImportRequest(request, payloadData, repositoryKey);
                return this.validate(request, push);
            }
            catch (JSONException e) {
                throw new ConverterException(request, (Throwable)e);
            }
        }
        throw new UnsupportedConverterException(request, this);
    }

    private PushImportRequest getPushImportRequest(HttpRequestData request, JSONObject payloadData, RepositoryKey repositoryKey) throws JSONException {
        PushImportRequest push = new PushImportRequest(repositoryKey, this.getProjectId(repositoryKey), payloadData.getString("after"));
        String resourcesConfig = request.getParameter("resourcesConfig");
        if (resourcesConfig != null) {
            push.setResourcesConfig(resourcesConfig);
        }
        return push;
    }

    private String convertChangesetUrlIntoRepoUrl(JSONObject commit) throws JSONException {
        return commit.getString(CHANGESET_URL).replaceFirst("/changesets/.*", ".git").replaceFirst("beanstalkapp.com", "git.beanstalkapp.com");
    }
}

