/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.beanstalkapp;

import com.google.code.regexp.Pattern;
import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.ProtocolType;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.vcs.git.GitRepositoryProtocol;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.stereotype.Component;

@Component(value="beanstalkappSSHProtocol")
public class BeanstalkappSSHProtocol
extends GitRepositoryProtocol {
    private static final Pattern URL_PATTERN = Pattern.compile((String)"^[^@]*@(?<host>[^:]*beanstalkapp\\.com):/?(?<path>.*)$");

    @Override
    public RepositoryKey getKeyFromUrl(RepositoryType type, String repositoryUrl, String branch) {
        Triple<String, String, String> keyData;
        RepositoryKey key = null;
        if (RepositoryType.GIT.equals((Object)type) && null != (keyData = this.getKeyByPattern(URL_PATTERN, repositoryUrl))) {
            String host = keyData.getMiddle();
            int index = host.indexOf(".");
            String path = keyData.getRight();
            if (-1 != index && path.startsWith(host.substring(0, index))) {
                key = new RepositoryKey(RepositoryType.GIT, ProtocolType.SSH, host, path.substring(index + 1), branch);
            }
        }
        return key;
    }

    @Override
    public boolean isApplicable(RepositoryKey key, AuthenticationData data) {
        return false;
    }
}

