/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.branch;

import com.smartling.api.v2.response.Error;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.model.ResourcePersistentData;
import com.smartling.repoconnector.services.CredentialsInvalidException;
import com.smartling.repoconnector.services.branch.BranchService;
import com.smartling.repoconnector.services.exception.SmartlingRestApiException;
import com.smartling.repoconnector.services.integration.ApiClientFactory;
import com.smartling.repoconnector.services.integration.FilesApiClient;
import com.smartling.repoconnector.services.persistence.RepositoryPersistenceService;
import com.smartling.repoconnector.services.persistence.ResourcePersistenceService;
import com.smartling.repoconnector.services.persistence.RevisionPersistenceService;
import com.smartling.repoconnector.services.persistence.dto.RepositoryDTO;
import com.smartling.repoconnector.services.vcs.Branch;
import com.smartling.repoconnector.services.vcs.RepositoryConnector;
import com.smartling.repoconnector.services.vcs.RepositoryFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BranchServiceImpl
implements BranchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BranchServiceImpl.class);
    private static final String FILE_NOT_FOUND_KEY = "file.not.found";
    @Autowired
    private RepositoryPersistenceService repositoryPersistenceService;
    @Autowired
    private ResourcePersistenceService resourcePersistenceService;
    @Autowired
    private RevisionPersistenceService revisionPersistenceService;
    @Autowired
    private RepositoryFactory repositoryFactory;
    @Autowired
    private ApiClientFactory fileApiFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanDeletedBranches(RepositoryKey repositoryKey) {
        try (RepositoryConnector connector = this.repositoryFactory.getConnector(repositoryKey);){
            MDC.put((String)"repositoryKey", (String)repositoryKey.toString());
            List<Branch> remoteBranches = connector.getBranches();
            Collection<RepositoryKey> repositoryKeys = this.getRepositoryKeyForEveryBranch(repositoryKey);
            this.processEveryRepositoryKey(remoteBranches, repositoryKeys);
        }
        catch (Exception e) {
            LOGGER.error("Exception while clean branches for repository key = '{}':", (Object)repositoryKey, (Object)e);
        }
        finally {
            MDC.clear();
        }
    }

    private void processEveryRepositoryKey(List<Branch> remoteBranches, Collection<RepositoryKey> repositoryKeys) throws Exception {
        for (RepositoryKey key : repositoryKeys) {
            String branch = key.getBranch();
            if (this.existsRemoteBranch(branch, remoteBranches)) continue;
            LOGGER.info("Cleaning branch '{}'", (Object)branch);
            this.cleanResources(key);
            this.removeFolderAndCleanRepositoryRelatedData(key);
            LOGGER.info("Cleaning branch '{}' data has been completed", (Object)branch);
        }
    }

    private Collection<RepositoryKey> getRepositoryKeyForEveryBranch(RepositoryKey repositoryKey) {
        List<RepositoryDTO> repositoryDTOs = this.repositoryPersistenceService.findAll(repositoryKey);
        Collection<String> downloadedBranches = this.mapToBranchNameLocal(repositoryDTOs);
        return this.mergeWithBranches(repositoryKey, downloadedBranches);
    }

    private void cleanResources(RepositoryKey repositoryKey) {
        try {
            FilesApiClient filesApiClient = this.fileApiFactory.getFileApi(repositoryKey);
            List<ResourcePersistentData> resources = this.resourcePersistenceService.findAll(repositoryKey);
            for (ResourcePersistentData resource : resources) {
                this.removeResource(repositoryKey, filesApiClient, resource);
            }
        }
        catch (CredentialsInvalidException e) {
            LOGGER.error("Invalid credentials", (Throwable)e);
        }
        catch (SmartlingRestApiException e) {
            LOGGER.error("Error while trying to delete files from Smartling[branchName='{}'], statusCode={}, requestId={}", new Object[]{repositoryKey.getBranch(), e.getStatusCode(), e.getRequestId(), e});
        }
    }

    private void removeResource(RepositoryKey repositoryKey, FilesApiClient filesApiClient, ResourcePersistentData resource) throws SmartlingRestApiException {
        String smartlingUri = resource.getSmartlingUri();
        try {
            filesApiClient.deleteFile(smartlingUri);
            LOGGER.info("Deleted file '{}' from smartling", (Object)smartlingUri);
            this.resourcePersistenceService.remove(repositoryKey, resource.getRepositoryPath());
            LOGGER.info("Deleted resource[repositoryKey ='{}', repositoryPath='{}']", (Object)repositoryKey, (Object)resource.getRepositoryPath());
        }
        catch (SmartlingRestApiException e) {
            LOGGER.warn("Got Smartling api exception during file deletion:", (Throwable)e);
            if (this.containsFileNotFoundError(e)) {
                this.resourcePersistenceService.remove(repositoryKey, resource.getRepositoryPath());
            }
            throw e;
        }
    }

    private boolean containsFileNotFoundError(SmartlingRestApiException e) {
        for (Error error : e.getErrors()) {
            if (!FILE_NOT_FOUND_KEY.equals(error.getKey())) continue;
            return true;
        }
        return false;
    }

    private void removeFolderAndCleanRepositoryRelatedData(RepositoryKey repositoryKey) throws Exception {
        int amountOfResources = this.resourcePersistenceService.count(repositoryKey);
        if (amountOfResources == 0) {
            if (repositoryKey.getType() == RepositoryType.SVN) {
                this.removeFolder(this.getRepositoryPath(repositoryKey));
            }
            this.revisionPersistenceService.remove(repositoryKey);
            LOGGER.info("Deleted revision for repositoryKey ='{}'", (Object)repositoryKey);
            this.repositoryPersistenceService.remove(repositoryKey);
            LOGGER.info("Deleted repository for repositoryKey ='{}'", (Object)repositoryKey);
        } else {
            LOGGER.warn("Not all resources connected to repositoryKey = {} is removed", (Object)repositoryKey);
        }
    }

    private String getRepositoryPath(RepositoryKey repositoryKey) throws Exception {
        try (RepositoryConnector repositoryConnector = this.repositoryFactory.getConnector(repositoryKey);){
            String string = repositoryConnector.localPath();
            return string;
        }
    }

    private void removeFolder(String path) {
        try {
            File directory = new File(path);
            if (directory.exists()) {
                FileUtils.deleteDirectory(directory);
                LOGGER.info("Deleted folder '{}'", (Object)directory);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error during deleting directory {}", (Object)path);
            throw new RuntimeException(e);
        }
    }

    private boolean existsRemoteBranch(String branch, List<Branch> remoteBranches) {
        return this.mapToBranchNameRemote(remoteBranches).contains(branch);
    }

    private Collection<String> mapToBranchNameRemote(List<Branch> branches) {
        HashSet<String> result = new HashSet<String>(branches.size(), 1.0f);
        for (Branch branch : branches) {
            result.add(branch.getName());
        }
        return result;
    }

    private Collection<String> mapToBranchNameLocal(List<RepositoryDTO> repositoryDTOs) {
        HashSet<String> result = new HashSet<String>(repositoryDTOs.size(), 1.0f);
        for (RepositoryDTO repositoryDTO : repositoryDTOs) {
            result.add(repositoryDTO.getBranch());
        }
        return result;
    }

    private Collection<RepositoryKey> mergeWithBranches(RepositoryKey repositoryKey, Collection<String> branches) {
        ArrayList<RepositoryKey> result = new ArrayList<RepositoryKey>(branches.size());
        for (String branch : branches) {
            result.add(repositoryKey.cloneForBranch(branch));
        }
        return result;
    }
}

