/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.event;

import java.util.Map;
import org.springframework.context.ApplicationEvent;

public class HealthEvent
extends ApplicationEvent {
    private static final long serialVersionUID = -5025509294074907820L;
    private boolean isOK = true;
    private String name;
    private Map<String, Object> parameters;
    private String error;

    public HealthEvent(Object source, String name) {
        super(source);
        this.name = name;
    }

    public HealthEvent(Object source, String name, Map<String, Object> parameters) {
        super(source);
        this.name = name;
        this.parameters = parameters;
    }

    public HealthEvent(Object source, String name, String error) {
        super(source);
        this.name = name;
        this.error = error;
        this.isOK = false;
    }

    public boolean isOk() {
        return this.isOK;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        String result = null;
        if (this.isOK) {
            result = this.name + " is OK";
            if (null != this.parameters && 0 < this.parameters.size()) {
                result = result + ", parameters " + this.parameters;
            }
        } else {
            result = this.name + " isn't working, error: " + this.error;
        }
        return result;
    }
}

