/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.exception;

import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import com.smartling.api.v2.response.Error;
import com.smartling.api.v2.response.ResponseCode;
import java.util.Collections;
import java.util.List;

public abstract class SmartlingRestApiException
extends Exception {
    private static final String REQUEST_ID_HEADER = "X-SL-RequestId";
    private final int statusCode;
    private final ResponseCode responseCode;
    private final List<Error> errors;
    private final String requestId;

    public SmartlingRestApiException(String message, RestApiRuntimeException e) {
        super(message, e);
        this.statusCode = e.getStatus();
        this.responseCode = e.getResponseCode();
        this.errors = Collections.unmodifiableList(e.getErrors());
        String objRequestId = e.getResponse().getHeaderString(REQUEST_ID_HEADER);
        this.requestId = objRequestId == null ? null : objRequestId.toString();
    }

    protected SmartlingRestApiException(String message, int statusCode, ResponseCode responseCode, List<Error> errors, String requestId) {
        super(message);
        this.statusCode = statusCode;
        this.responseCode = responseCode;
        this.errors = errors != null ? Collections.unmodifiableList(errors) : Collections.emptyList();
        this.requestId = requestId;
    }

    public static String getRequestIdHeader() {
        return REQUEST_ID_HEADER;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public String getRequestId() {
        return this.requestId;
    }
}

