/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.github;

import com.smartling.repoconnector.services.beanstalkapp.AbstractAuthRequestVoteEventProcessor;
import com.smartling.repoconnector.services.event.PushRequestVoteEvent;
import com.typesafe.config.Config;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GithubAuthRequestVoteEventProcessor
extends AbstractAuthRequestVoteEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GithubAuthRequestVoteEventProcessor.class);
    static final String PROJECT_TOKEN_SECRET_CONFIG_PATH = "tokenSecret";

    @Override
    protected boolean isSupported(PushRequestVoteEvent pushRequestVoteEvent) {
        return pushRequestVoteEvent.getSource() == PushRequestVoteEvent.Source.GITHUB;
    }

    @Override
    protected boolean isVote(PushRequestVoteEvent pushRequestVoteEvent, Config repositoryConfig) {
        try {
            String tokenSecretValue = repositoryConfig.getConfig("smartlingProject").getString(PROJECT_TOKEN_SECRET_CONFIG_PATH);
            String signature = "sha1=" + GithubAuthRequestVoteEventProcessor.computeSignature(pushRequestVoteEvent.getRequestData().getBody(), tokenSecretValue);
            String headerValue = pushRequestVoteEvent.getRequestData().getHeader("X-Hub-Signature");
            return headerValue.equals(signature);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            LOGGER.error("Error during computing hash signature:", (Throwable)e);
            return false;
        }
    }

    private static String computeSignature(String baseString, String keyString) throws GeneralSecurityException, UnsupportedEncodingException {
        Mac hmacSha1;
        try {
            hmacSha1 = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            hmacSha1 = Mac.getInstance("HMAC-SHA-1");
        }
        SecretKeySpec macKey = new SecretKeySpec(keyString.getBytes(), "RAW");
        hmacSha1.init(macKey);
        byte[] hash = hmacSha1.doFinal(baseString.getBytes());
        return Hex.encodeHexString((byte[])hash);
    }
}

