/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.github;

import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.AuthenticationType;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.event.RequestVoteEvent;
import com.smartling.repoconnector.services.github.AbstractGithubProtocol;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.stereotype.Component;

@Component(value="githubHttpOAuthProtocol")
public class GithubHttpOAuthProtocol
extends AbstractGithubProtocol {
    private static Logger logger = LoggerFactory.getLogger(GithubHttpOAuthProtocol.class);
    private static final String URL_CODE_REQUEST = "https://github.com/login/oauth/authorize?";
    private static final String URL_ACCESS_TOKEN_REQUEST = "https://github.com/login/oauth/access_token";
    private static final String PARAM_REDIRECTURI_NAME = "redirect_uri";
    private static final String PARAM_SCOPE_NAME = "scope";
    private static final String PARAM_SCOPE_VALUE = "repo,public_repo";
    private static final String PARAM_CLIENTID_NAME = "client_id";
    private static final String PARAM_CLIENTSECRET_NAME = "client_secret";
    private static final String PARAM_CODE_NAME = "code";
    private static final Pattern PATTERN_ACCESS_TOKEN_EXTRACT = Pattern.compile("access_token=\\w+");
    @Value(value="${http.callbackUrl}")
    private String callBackUrl;
    @Value(value="${vcs.github.oauth.callbackTimeout}")
    private Long callBackTimeout;
    @Autowired
    private ApplicationEventMulticaster listenerRegistry;

    @Override
    public RepositoryKey getKeyFromUrl(RepositoryType type, String repositoryUrl, String branch) {
        return null;
    }

    @Override
    public boolean isApplicable(RepositoryKey key, AuthenticationData data) {
        return super.isApplicable(key, data) && AuthenticationType.OAUTH_ACCESS_TOKEN.equals((Object)data.getAuthenticationType());
    }

    @Override
    public CredentialsProvider getCredentialsProvider(RepositoryKey key, AuthenticationData credential) {
        UsernamePasswordCredentialsProvider provider = null;
        if (AuthenticationType.OAUTH_ACCESS_TOKEN.equals((Object)credential.getAuthenticationType()) && 3 == credential.getTokens().length) {
            provider = new UsernamePasswordCredentialsProvider(credential.getTokens()[0], credential.getTokens()[2]);
        } else if (AuthenticationType.OAUTH_ACCESS_TOKEN.equals((Object)credential.getAuthenticationType()) && 2 == credential.getTokens().length) {
            String accessToken = this.getToken(credential.getTokens()[0], credential.getTokens()[1]);
            if (null != accessToken) {
                String[] tokens = new String[]{credential.getTokens()[0], credential.getTokens()[1], accessToken};
                credential.setTokens(tokens);
            }
            provider = new UsernamePasswordCredentialsProvider(credential.getTokens()[0], accessToken);
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized String getToken(String clientId, String clientSecret) {
        String accessToken = null;
        CallbackHandler handler = new CallbackHandler();
        try {
            this.listenerRegistry.addApplicationListener((ApplicationListener)handler);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair(PARAM_CLIENTID_NAME, clientId));
            params.add(new BasicNameValuePair(PARAM_SCOPE_NAME, PARAM_SCOPE_VALUE));
            params.add(new BasicNameValuePair(PARAM_REDIRECTURI_NAME, new URL(new URL(this.callBackUrl), "callback").toString()));
            String requestUri = URL_CODE_REQUEST + URLEncodedUtils.format(params, (String)"utf-8");
            Process browser = GithubHttpOAuthProtocol.openBrowser(requestUri);
            if (null != browser) {
                this.wait(this.callBackTimeout * 1000L);
                String code = handler.getToken();
                if (null != code) {
                    accessToken = this.sendAccessTokenRequest(clientId, clientSecret, code);
                }
            }
        }
        catch (Exception e) {
            logger.error("Authentication error!", (Throwable)e);
        }
        finally {
            this.listenerRegistry.removeApplicationListener((ApplicationListener)handler);
        }
        return accessToken;
    }

    private String sendAccessTokenRequest(String clientId, String clientSecret, String code) throws ClientProtocolException, IOException {
        String body;
        Matcher matcher;
        String accessToken = null;
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(PARAM_CLIENTID_NAME, clientId));
        params.add(new BasicNameValuePair(PARAM_CLIENTSECRET_NAME, clientSecret));
        params.add(new BasicNameValuePair(PARAM_CODE_NAME, code));
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(URL_ACCESS_TOKEN_REQUEST);
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        HttpResponse response = client.execute((HttpUriRequest)post);
        if (200 == response.getStatusLine().getStatusCode() && (matcher = PATTERN_ACCESS_TOKEN_EXTRACT.matcher(body = IOUtils.toString(response.getEntity().getContent(), "UTF-8"))).find()) {
            String token = matcher.group();
            accessToken = token.substring(body.indexOf("=") + 1);
        }
        return accessToken;
    }

    private static Process openBrowser(String url) throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        Runtime rt = Runtime.getRuntime();
        Process browser = null;
        if (os.indexOf("win") >= 0) {
            browser = rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else if (os.indexOf("mac") >= 0) {
            browser = rt.exec("open " + url);
        } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
            StringBuffer cmd = new StringBuffer();
            for (int i = 0; i < browsers.length; ++i) {
                cmd.append((i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
            }
            browser = rt.exec(new String[]{"sh", "-c", cmd.toString()});
        }
        return browser;
    }

    private class CallbackHandler
    implements ApplicationListener<RequestVoteEvent> {
        private String token;

        private CallbackHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onApplicationEvent(RequestVoteEvent event) {
            if ("callback".equals(event.getRequestData().getContext())) {
                GithubHttpOAuthProtocol githubHttpOAuthProtocol = GithubHttpOAuthProtocol.this;
                synchronized (githubHttpOAuthProtocol) {
                    this.token = event.getRequestData().getParameter(GithubHttpOAuthProtocol.PARAM_CODE_NAME);
                    event.vote(true);
                    GithubHttpOAuthProtocol.this.notify();
                }
            }
        }

        public String getToken() {
            return this.token;
        }
    }
}

