/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.github;

import com.smartling.repoconnector.model.AuthenticationData;
import com.smartling.repoconnector.model.AuthenticationType;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.github.AbstractGithubProtocol;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.springframework.stereotype.Component;

@Component(value="githubPersonalTokenProtocol")
public class GithubHttpPersonalTokenProtocol
extends AbstractGithubProtocol {
    private static final String OAUTH_BASIC_PWD = "x-oauth-basic";

    @Override
    public RepositoryKey getKeyFromUrl(RepositoryType type, String repositoryUrl, String branch) {
        return null;
    }

    @Override
    public boolean isApplicable(RepositoryKey key, AuthenticationData data) {
        return super.isApplicable(key, data) && AuthenticationType.PERSONAL_TOKEN.equals((Object)data.getAuthenticationType());
    }

    @Override
    public CredentialsProvider getCredentialsProvider(RepositoryKey key, AuthenticationData credential) {
        return new UsernamePasswordCredentialsProvider(credential.getTokens()[0], OAUTH_BASIC_PWD);
    }
}

