/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.github;

import com.smartling.repoconnector.model.HttpRequestData;
import com.smartling.repoconnector.model.PushImportRequest;
import com.smartling.repoconnector.services.github.GithubWebPushConverter;
import com.smartling.repoconnector.services.http.converter.ConverterException;
import com.smartling.repoconnector.services.http.converter.UnsupportedConverterException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class GithubRubyPushConverter
extends GithubWebPushConverter {
    @Override
    public PushImportRequest convert(HttpRequestData request) throws ConverterException {
        if ("github".equals(request.getContext()) && null == request.getHeader("X-Github-Event") && null != request.getBody()) {
            try {
                JSONObject payload = new JSONObject(request.getBody());
                request.setParameter("userIdentifier", payload.optString("userIdentifier"));
                request.setParameter("tokenSecret", payload.optString("tokenSecret"));
                request.setParameter("projectId", payload.optString("projectId"));
                return this.convert(request, payload);
            }
            catch (JSONException e) {
                throw new ConverterException(request, (Throwable)e);
            }
        }
        throw new UnsupportedConverterException(request, this);
    }
}

