/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.github;

import com.smartling.repoconnector.model.HttpRequestData;
import com.smartling.repoconnector.model.PushImportRequest;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.http.converter.AbstractPushConverter;
import com.smartling.repoconnector.services.http.converter.ConverterException;
import com.smartling.repoconnector.services.http.converter.UnsupportedConverterException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class GithubWebPushConverter
extends AbstractPushConverter {
    protected static final String EVENT_TYPE_ATTRIBUTE = "X-Github-Event";
    private static final String REF_ATTRIBUTE = "ref";
    private static final String URL_ATTRIBUTE = "clone_url";
    private static final String REPOSITORY_ATTRIBUTE = "repository";
    private static final String PUSH_EVENT_VALUE = "push";

    @Override
    public PushImportRequest convert(HttpRequestData request) throws ConverterException {
        if ("github".equals(request.getContext()) && PUSH_EVENT_VALUE.equals(request.getHeader(EVENT_TYPE_ATTRIBUTE))) {
            try {
                return this.convert(request, new JSONObject(request.getBody()));
            }
            catch (JSONException e) {
                throw new ConverterException(request, (Throwable)e);
            }
        }
        throw new UnsupportedConverterException(request, this);
    }

    protected PushImportRequest convert(HttpRequestData request, JSONObject payload) throws ConverterException, JSONException {
        JSONObject repository = payload.getJSONObject(REPOSITORY_ATTRIBUTE);
        String ref = payload.getString(REF_ATTRIBUTE);
        String[] refs = ref.split("/");
        RepositoryKey repositoryKey = this.getRepositoryKey(RepositoryType.GIT, repository.getString(URL_ATTRIBUTE), refs[refs.length - 1]);
        PushImportRequest push = this.getPushImportRequest(request, payload, repositoryKey);
        return this.validate(request, push);
    }

    private PushImportRequest getPushImportRequest(HttpRequestData request, JSONObject payload, RepositoryKey repositoryKey) throws JSONException {
        PushImportRequest push = new PushImportRequest(repositoryKey, this.getProjectId(repositoryKey), payload.getString("after"));
        String resourcesConfig = request.getParameter("resourcesConfig");
        if (resourcesConfig != null) {
            push.setResourcesConfig(resourcesConfig);
        }
        return push;
    }
}

