/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.hooks;

import com.smartling.repoconnector.model.ChangeType;
import com.smartling.repoconnector.model.ProjectData;
import com.smartling.repoconnector.model.RepositoryResourceChange;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.hooks.SystemOperations;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HookExecutor {
    private static Logger logger = LoggerFactory.getLogger(HookExecutor.class);
    private static final String MODIFIED_FILES_VAR = "MODIFIED_FILES";
    @Autowired
    private SystemOperations systemOperations;

    public List<RepositoryResourceChange> executePostCheckoutHook(ProjectData projectData, String repositoryLocalRoot, List<RepositoryResourceChange> changes) throws ServiceException {
        if (StringUtils.isBlank(projectData.getPostCheckOutHook())) {
            return changes;
        }
        List<String> preHookedModifiedFilesList = this.prepareModifiedFilesList(changes);
        File modifiedFiles = this.systemOperations.saveToTempFile(preHookedModifiedFilesList);
        Map<String, String> environment = Collections.singletonMap(MODIFIED_FILES_VAR, modifiedFiles.getAbsolutePath());
        this.systemOperations.executeHook(projectData.getPostCheckOutHook(), environment, new File(repositoryLocalRoot));
        List<String> normalizedFilePaths = this.systemOperations.normalizeFilePaths(this.systemOperations.readListFromFile(modifiedFiles), repositoryLocalRoot);
        return this.mergeModifiedResourcesWithHookedResult(changes, normalizedFilePaths);
    }

    public Collection<String> executePreCommitHook(ProjectData projectData, String repositoryLocalRoot, Collection<String> filesToCommit) throws ServiceException {
        if (StringUtils.isBlank(projectData.getPreCommitHook())) {
            return filesToCommit;
        }
        File modifiedFiles = this.systemOperations.saveToTempFile(filesToCommit);
        Map<String, String> environment = Collections.singletonMap(MODIFIED_FILES_VAR, modifiedFiles.getAbsolutePath());
        this.systemOperations.executeHook(projectData.getPreCommitHook(), environment, new File(repositoryLocalRoot));
        List<String> normalizedFilePaths = this.systemOperations.normalizeFilePaths(this.systemOperations.readListFromFile(modifiedFiles), repositoryLocalRoot);
        return normalizedFilePaths;
    }

    private List<RepositoryResourceChange> mergeModifiedResourcesWithHookedResult(List<RepositoryResourceChange> changes, List<String> hookedFilesList) {
        ArrayList<RepositoryResourceChange> mergedChanges = new ArrayList<RepositoryResourceChange>();
        HashMap<String, RepositoryResourceChange> changesMapped = new HashMap<String, RepositoryResourceChange>();
        for (RepositoryResourceChange change : changes) {
            if (change.getType() != ChangeType.DELETE) {
                changesMapped.put(change.getNewPath(), change);
                continue;
            }
            mergedChanges.add(change);
        }
        for (String filePath : hookedFilesList) {
            if (changesMapped.containsKey(filePath)) {
                mergedChanges.add((RepositoryResourceChange)changesMapped.get(filePath));
                continue;
            }
            RepositoryResourceChange externalChange = new RepositoryResourceChange(ChangeType.MODIFY, filePath, filePath);
            mergedChanges.add(externalChange);
        }
        return mergedChanges;
    }

    private List<String> prepareModifiedFilesList(List<RepositoryResourceChange> changes) {
        ArrayList<String> filesList = new ArrayList<String>(changes.size());
        for (RepositoryResourceChange change : changes) {
            if (change.getType() == ChangeType.DELETE) continue;
            filesList.add(change.getNewPath());
        }
        return filesList;
    }
}

