/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.hooks;

import com.smartling.repoconnector.services.ServiceException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SystemOperations {
    private static Logger logger = LoggerFactory.getLogger(SystemOperations.class);
    private static final String PREFIX = "hook-";
    private static final String SUFFIX = ".tmp";

    public File saveToTempFile(Collection<String> fileList) throws ServiceException {
        logger.info("Saving fileList to temp file:\n{}", (Object)String.join((CharSequence)"\n", fileList));
        try {
            File file = File.createTempFile(PREFIX, SUFFIX);
            FileUtils.writeLines(file, fileList);
            return file;
        }
        catch (IOException e) {
            logger.error("Couldn't create temp file: ", (Throwable)e);
            throw new ServiceException("Error while creating temp file for hook", e);
        }
    }

    public List<String> readListFromFile(File modifiedFiles) throws ServiceException {
        try {
            List<String> fileList = FileUtils.readLines(modifiedFiles, StandardCharsets.UTF_8);
            logger.info("Read fileList from temp file:\n{}", (Object)String.join((CharSequence)"\n", fileList));
            return fileList;
        }
        catch (IOException e) {
            throw new ServiceException("Can't read hooked fileNames list from the temp file", e);
        }
    }

    public void executeHook(String command, Map<String, String> environment, File rootDir) throws ServiceException {
        try {
            logger.info("Running hook command: \"{}\"", (Object)command);
            ProcessBuilder pb = new ProcessBuilder(this.tokenizeCommand(command)).directory(rootDir);
            Map<String, String> processEnvironment = pb.environment();
            processEnvironment.putAll(environment);
            Process process = pb.start();
            int exitCode = process.waitFor();
            logger.info("Std Out: " + IOUtils.toString(process.getInputStream(), StandardCharsets.UTF_8));
            String stdError = IOUtils.toString(process.getErrorStream(), StandardCharsets.UTF_8);
            if (exitCode != 0) {
                logger.error("Std Err: " + stdError);
                logger.error("Hook execution finished with exit code {}", (Object)exitCode);
                throw new ServiceException("Hook script returned exit code " + exitCode);
            }
            logger.debug("Std Err:");
            logger.info("Hook execution finished with exit code {}", (Object)exitCode);
        }
        catch (IOException | InterruptedException e) {
            logger.error("Couldn't execute hook command \"{}\"\"", (Object)command, (Object)e);
            throw new ServiceException("Couldn't execute hook command", e);
        }
    }

    public List<String> normalizeFilePaths(List<String> fileNames, String rootPath) throws ServiceException {
        ArrayList<String> normalizedFileNames = new ArrayList<String>(fileNames.size());
        Path root = Paths.get(rootPath, new String[0]);
        for (String fileName : fileNames) {
            try {
                Path fullNormalizedPath = root.resolve(fileName).normalize();
                Path relativeNormalizedPath = root.relativize(fullNormalizedPath);
                normalizedFileNames.add(relativeNormalizedPath.toString());
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException("Can't normalize path \"" + fileName + "\" with the given root path \"" + rootPath + "\"", e);
            }
        }
        return normalizedFileNames;
    }

    private List<String> tokenizeCommand(String command) {
        StringTokenizer st = new StringTokenizer(command);
        ArrayList<String> cmdarray = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            cmdarray.add(st.nextToken());
        }
        return cmdarray;
    }
}

