/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.http;

import com.smartling.repoconnector.model.HttpRequestData;
import com.smartling.repoconnector.services.event.PushRequestVoteEvent;
import com.smartling.repoconnector.services.event.RequestVoteEvent;
import com.smartling.repoconnector.services.http.HTTPAttributes;
import com.smartling.repoconnector.services.http.converter.ConverterException;
import com.smartling.repoconnector.services.http.converter.PushConverter;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@Provider
public class AuthFilter
implements ContainerRequestFilter {
    private static Logger logger = LoggerFactory.getLogger(AuthFilter.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    @Qualifier(value="compositeConverter")
    private PushConverter pushConverter;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = requestContext.getUriInfo().getPath(true);
        if (logger.isTraceEnabled()) {
            logger.trace("Request {} is receiving", (Object)path);
        }
        if ("application.wadl".equals(path) || "application.wadl/xsd0.xsd".equals(path) || "favicon.ico".equals(path)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        HttpRequestData requestData = new HttpRequestData(path, (MultivaluedMap<String, String>)requestContext.getUriInfo().getQueryParameters(), (MultivaluedMap<String, String>)requestContext.getHeaders(), this.extractBody(requestContext));
        RequestVoteEvent requestEvent = this.getRequestVoteEvent(requestContext, path, requestData);
        this.eventPublisher.publishEvent((ApplicationEvent)requestEvent);
        if (!requestEvent.isVoted()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Request {} is accepted", (Object)path);
        }
    }

    private RequestVoteEvent getRequestVoteEvent(ContainerRequestContext request, String path, HttpRequestData requestData) {
        RequestVoteEvent requestEvent;
        if (HTTPAttributes.VCS_CONTEXTS.contains(path)) {
            try {
                requestEvent = new PushRequestVoteEvent(this, requestData, this.pushConverter.convert(requestData), PushRequestVoteEvent.Source.valueOf(path.toUpperCase()));
            }
            catch (ConverterException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Push request {} payload error", (Object)path, (Object)e);
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            this.changeRequestContext(request);
        } else {
            requestEvent = new RequestVoteEvent(this, requestData);
        }
        return requestEvent;
    }

    private void changeRequestContext(ContainerRequestContext request) {
        String oldRequestUri = request.getUriInfo().getRequestUri().toString();
        int index = oldRequestUri.indexOf("?");
        String requestUri = request.getUriInfo().getBaseUri() + "push" + (-1 == index ? "" : oldRequestUri.substring(index));
        request.setRequestUri(URI.create(requestUri));
    }

    private String extractBody(ContainerRequestContext request) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = request.getEntityStream();
        StringBuilder b = new StringBuilder();
        try {
            if (in != null && in.available() > 0) {
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                byte[] entity = out.toByteArray();
                if (entity.length > 0) {
                    b.append(new String(entity));
                }
                request.setEntityStream((InputStream)new ByteArrayInputStream(entity));
            }
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return b.toString();
    }
}

