/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.http;

import com.smartling.repoconnector.services.AbstractService;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.event.HealthEvent;
import com.smartling.repoconnector.services.http.AuthFilter;
import com.smartling.repoconnector.services.http.HTTPListener;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.glassfish.jersey.server.spring.SpringComponentProvider;
import org.glassfish.jersey.simple.SimpleContainerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class HTTPSJerseyListener
extends AbstractService
implements HTTPListener {
    private static Logger logger = LoggerFactory.getLogger(HTTPSJerseyListener.class);
    private static final String HTTPS_PROTOCOL = "protocol";
    private static final String HTTPS_KEY_PASS = "keyPass";
    private static final String HTTPS_KEYSTORE_PASS = "keystorePass";
    private static final String HTTPS_KEYSTORE_FILE = "keystoreFile";
    private static final String HTTPS_KEYSTORE_TYPE = "keystoreType";
    private static final String SSL_PROTOCOL = "https";
    private Closeable server = null;
    @Autowired
    private Config configuration;
    @Autowired
    private ConfigurableApplicationContext context;
    @Value(value="${http.host}")
    private String host;
    @Value(value="${http.port}")
    private Integer port;
    @Value(value="${http.protocol}")
    private String protocol;

    @Override
    public void start() throws ServiceException {
        try {
            URI uri = new URI(this.protocol, null, this.host, this.port, "/", null, null);
            ResourceConfig config = new ResourceConfig();
            config.register(AuthFilter.class);
            config.register(FreemarkerMvcFeature.class);
            config.property("jersey.config.server.mvc.templateBasePath.freemarker", (Object)"freemarker");
            config.packages(new String[]{"com.smartling.repoconnector.services.http.handlers"});
            config.property("contextConfig", (Object)this.context);
            config.register(SpringComponentProvider.class);
            this.server = this.createServer(uri, config, this.prepareContext());
            logger.info("HTTP listener is started on {}://{}:{}", new Object[]{this.protocol, this.host, this.port});
        }
        catch (Exception e) {
            logger.error("HTTP listener starting error {}://{}:{}", new Object[]{this.protocol, this.host, this.port});
            throw new ServiceException(e);
        }
    }

    @Override
    public void stop() throws ServiceException {
        try {
            this.server.close();
            logger.info("HTTP listener is stopped on {}://{}:{}", new Object[]{this.protocol, this.host, this.port});
        }
        catch (Exception e) {
            logger.error("HTTP listener stopping error {}://{}:{}", new Object[]{this.protocol, this.host, this.port});
            throw new ServiceException(e);
        }
    }

    @Override
    public void check() {
        this.fireEvent(new HealthEvent(this, this.getClass().getSimpleName()));
    }

    protected Closeable createServer(URI uri, ResourceConfig config, SSLContext sslContext) {
        return SimpleContainerFactory.create((URI)uri, (SSLContext)sslContext, (ResourceConfig)config);
    }

    private SSLContext prepareContext() throws Exception {
        SSLContext sslContext = null;
        if (SSL_PROTOCOL.equals(this.protocol)) {
            Config httpConfig = this.configuration.getConfig("http.ssl");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance(httpConfig.getString(HTTPS_KEYSTORE_TYPE));
            File keystoreFile = new File(this.getConfigurationDirectory(), httpConfig.getString(HTTPS_KEYSTORE_FILE));
            if (!keystoreFile.exists()) {
                keystoreFile = new File(httpConfig.getString(HTTPS_KEYSTORE_FILE));
            }
            FileInputStream fin = new FileInputStream(keystoreFile);
            ks.load(fin, httpConfig.getString(HTTPS_KEYSTORE_PASS).toCharArray());
            kmf.init(ks, httpConfig.getString(HTTPS_KEY_PASS).toCharArray());
            sslContext = SSLContext.getInstance(httpConfig.getString(HTTPS_PROTOCOL));
            sslContext.init(kmf.getKeyManagers(), null, null);
        }
        return sslContext;
    }
}

