/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.http.converter;

import com.smartling.repoconnector.model.HttpRequestData;
import com.smartling.repoconnector.model.PushImportRequest;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.RepositoryType;
import com.smartling.repoconnector.services.http.converter.ConverterException;
import com.smartling.repoconnector.services.http.converter.PushConverter;
import com.smartling.repoconnector.services.vcs.RepositoryFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPushConverter
implements PushConverter {
    protected static final String AFTER_REVISION_ATTRIBUTE = "after";
    @Autowired
    private RepositoryFactory repositoryFactory;

    protected PushImportRequest validate(HttpRequestData requestData, PushImportRequest push) throws ConverterException {
        if (null == push.getRepositoryKey()) {
            throw new ConverterException(requestData, "Incorrect repository");
        }
        return push;
    }

    protected RepositoryKey getRepositoryKey(RepositoryType type, String repositoryUrl, String branch) {
        return this.repositoryFactory.getKeyFromUrl(type, repositoryUrl, branch);
    }

    protected String getProjectId(RepositoryKey repositoryKey) {
        return this.repositoryFactory.getProjectData(repositoryKey).getProjectId();
    }
}

