/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.http.converter;

import com.smartling.repoconnector.model.HttpRequestData;
import com.smartling.repoconnector.model.PushImportRequest;
import com.smartling.repoconnector.services.http.converter.ConverterException;
import com.smartling.repoconnector.services.http.converter.PushConverter;
import com.smartling.repoconnector.services.http.converter.UnsupportedConverterException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="compositeConverter")
public class ConverterComposite
implements PushConverter {
    @Autowired
    private List<PushConverter> converters;
    private ThreadLocal<PushImportRequest> cache = new ThreadLocal();

    @Override
    public PushImportRequest convert(HttpRequestData request) throws ConverterException {
        PushImportRequest result = null;
        if ("push".equals(request.getContext())) {
            result = this.cache.get();
            if (null == result) {
                throw new ConverterException(request, "The request wasn't previously converter");
            }
            this.cache.remove();
        } else {
            for (PushConverter converter : this.converters) {
                try {
                    result = converter.convert(request);
                    break;
                }
                catch (ConverterException converterException) {
                }
            }
            if (null == result) {
                throw new UnsupportedConverterException(request, this);
            }
            this.cache.set(result);
        }
        return result;
    }
}

