/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.http.handlers;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.smartling.repoconnector.model.ImportRequest;
import com.smartling.repoconnector.model.ImportResult;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.importer.Importer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractImportHandler {
    private Logger logger;
    @Autowired
    @Qualifier(value="proxyImporter")
    private Importer<ImportRequest> importer;
    @Autowired
    private MetricRegistry metricRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ImportResult> importData(ImportRequest data) throws ServiceException {
        Timer.Context timerContext = this.metricRegistry.timer(MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{"processingTime"})).time();
        try {
            MDC.put((String)"projectId", (String)data.getProjectId());
            MDC.put((String)"repositoryKey", (String)data.getRepositoryKey().toString());
            MDC.put((String)"type", (String)data.getImportType().name());
            List<ImportResult> result = this.importer.importData(data);
            this.getLogger().trace("Import request data is put to queue {}", (Object)data);
            List<ImportResult> list = result;
            return list;
        }
        finally {
            MDC.clear();
            timerContext.stop();
        }
    }

    protected Logger getLogger() {
        if (null == this.logger) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }
}

