/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.http.handlers;

import com.smartling.repoconnector.model.ResourcePersistentData;
import com.smartling.repoconnector.services.event.RequestVoteEvent;
import com.smartling.repoconnector.services.manager.BrokerManager;
import com.smartling.repoconnector.services.persistence.ResourcePersistenceService;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.jersey.server.mvc.Viewable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.stereotype.Component;

@Component
@Path(value="/health")
public class HealthHandler
implements ApplicationListener<RequestVoteEvent> {
    private static final String RESOURCES_MODEL_NAME = "resources";
    private static final String COMPONENTS_MODEL_NAME = "components";
    @Autowired
    private BrokerManager manager;
    @Autowired
    private ApplicationEventMulticaster listenerRegistry;
    @Autowired
    private ResourcePersistenceService persistenceService;

    @GET
    @Produces(value={"text/html"})
    public Viewable getResponse() {
        ArrayList componentsHealth = new ArrayList();
        ApplicationListener listener = componentsHealth::add;
        this.listenerRegistry.addApplicationListener(listener);
        try {
            this.manager.check();
        }
        finally {
            this.listenerRegistry.removeApplicationListener(listener);
        }
        return new Viewable("/health", Collections.singletonMap(COMPONENTS_MODEL_NAME, componentsHealth));
    }

    @GET
    @Path(value="/db")
    @Produces(value={"text/html"})
    public Viewable getDb() {
        List<ResourcePersistentData> resources = this.persistenceService.findAll();
        return new Viewable("/resources", Collections.singletonMap(RESOURCES_MODEL_NAME, resources));
    }

    public void onApplicationEvent(RequestVoteEvent event) {
        if (event.getRequestData().getContext().startsWith("health")) {
            event.vote(true);
        }
    }
}

