/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.http.handlers;

import com.smartling.repoconnector.model.ResourcePersistentData;
import com.smartling.repoconnector.model.TranslationImportRequest;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.event.RequestVoteEvent;
import com.smartling.repoconnector.services.http.handlers.AbstractImportHandler;
import com.smartling.repoconnector.services.persistence.ResourcePersistenceService;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@Path(value="/smartling")
public class SmartlingHandler
extends AbstractImportHandler
implements ApplicationListener<RequestVoteEvent> {
    @Autowired
    private ResourcePersistenceService persistenceService;
    @Value(value="${smartling.localePattern}")
    private String smartlingLocalePattern;

    @GET
    @Produces(value={"text/html"})
    public String receiveNotification(@QueryParam(value="fileUri") String smartlingUri, @QueryParam(value="locale") String locale) throws ServiceException {
        ResourcePersistentData resourceData = this.persistenceService.findBySmartlingUri(smartlingUri);
        this.importData(new TranslationImportRequest(resourceData, List.of(locale), true));
        return "";
    }

    public void onApplicationEvent(RequestVoteEvent event) {
        if ("smartling".equals(event.getRequestData().getContext())) {
            String smartlingUri = event.getRequestData().getParameter("fileUri");
            String locale = event.getRequestData().getParameter("locale");
            event.vote(StringUtils.isNotBlank(locale) && locale.matches(this.smartlingLocalePattern) && StringUtils.isNotBlank(smartlingUri) && null != this.persistenceService.findBySmartlingUri(smartlingUri));
        }
    }
}

