/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.http.handlers;

import com.smartling.repoconnector.model.ImportRequest;
import com.smartling.repoconnector.model.PollImportRequest;
import com.smartling.repoconnector.model.ProjectData;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.event.RequestVoteEvent;
import com.smartling.repoconnector.services.importer.Importer;
import com.smartling.repoconnector.services.scheduler.TranslationStatusChecker;
import com.smartling.repoconnector.services.vcs.data.RepositoryDataProvider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@Path(value="/tasks")
public class TasksHandler
implements ApplicationListener<RequestVoteEvent> {
    private static Logger logger = LoggerFactory.getLogger(TasksHandler.class);
    private TranslationStatusChecker translationStatusChecker;
    private RepositoryDataProvider repositoryDataProvider;
    private Importer<ImportRequest> importer;

    @Autowired
    public TasksHandler(TranslationStatusChecker translationStatusChecker, RepositoryDataProvider repositoryDataProvider, @Qualifier(value="proxyImporter") Importer<ImportRequest> importer) {
        this.translationStatusChecker = translationStatusChecker;
        this.repositoryDataProvider = repositoryDataProvider;
        this.importer = importer;
    }

    @GET
    @Path(value="/update-translation-progress")
    public Response updateTranslationProgress() {
        try {
            logger.info("Triggering check status task...");
            this.translationStatusChecker.checkStatus();
            logger.info("Check status task triggered");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"OK").build();
        }
        catch (Exception e) {
            logger.error("Triggering check status task failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/pull-all-repositories")
    public Response pullRepositories() {
        StringBuilder failedResponse = new StringBuilder();
        Response.Status status = Response.Status.OK;
        for (RepositoryKey repositoryKey : this.repositoryDataProvider.getRepositoryKeys()) {
            ProjectData projectData = this.repositoryDataProvider.getProjectData(repositoryKey);
            try {
                PollImportRequest importRequest = new PollImportRequest(repositoryKey, projectData.getProjectId());
                MDC.put((String)"projectId", (String)importRequest.getProjectId());
                MDC.put((String)"repositoryKey", (String)importRequest.getRepositoryKey().toString());
                MDC.put((String)"type", (String)importRequest.getImportType().toString());
                logger.info("Triggering polling repository...");
                this.importer.importData(importRequest);
                logger.info("Polling repository triggered");
            }
            catch (ServiceException e) {
                logger.error("Triggering polling repository failed", (Throwable)e);
                failedResponse.append("\n\n").append(String.format("Failed to trigger polling for project %s and repository %s", repositoryKey, projectData.getProjectId()));
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
            finally {
                MDC.clear();
            }
        }
        return Response.status((Response.Status)status).entity((Object)(status == Response.Status.OK ? "OK" : failedResponse.toString())).build();
    }

    public void onApplicationEvent(RequestVoteEvent event) {
        if (event.getRequestData().getContext().startsWith("tasks")) {
            event.vote(true);
        }
    }
}

