/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.importer;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.smartling.api.files.v2.pto.FileLocaleLastModifiedPTO;
import com.smartling.api.files.v2.pto.GetFileLastModifiedPTO;
import com.smartling.repoconnector.model.EvaluationResult;
import com.smartling.repoconnector.model.ImportResult;
import com.smartling.repoconnector.model.ImportStatus;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.model.ResourcePersistentData;
import com.smartling.repoconnector.model.ResourceStatus;
import com.smartling.repoconnector.model.TranslationImportRequest;
import com.smartling.repoconnector.model.VcsResourceUpdate;
import com.smartling.repoconnector.services.DateFormatter;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.hooks.HookExecutor;
import com.smartling.repoconnector.services.importer.Importer;
import com.smartling.repoconnector.services.importer.pathevaluator.PathEvaluator;
import com.smartling.repoconnector.services.integration.ApiClientFactory;
import com.smartling.repoconnector.services.integration.FilesApiClient;
import com.smartling.repoconnector.services.integration.uploader.SmartlingApiFacade;
import com.smartling.repoconnector.services.persistence.ResourcePersistenceService;
import com.smartling.repoconnector.services.utils.FileOperations;
import com.smartling.repoconnector.services.utils.ResourceUtils;
import com.smartling.repoconnector.services.vcs.RepositoryConnector;
import com.smartling.repoconnector.services.vcs.RepositoryFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class Smartling2VcsImporterImpl
implements Importer<TranslationImportRequest> {
    private static Logger logger = LoggerFactory.getLogger(Smartling2VcsImporterImpl.class);
    @Autowired
    private ResourcePersistenceService persistenceService;
    @Autowired
    private HookExecutor hookExecutor;
    @Autowired
    private RepositoryFactory repositoryFactory;
    @Autowired
    private SmartlingApiFacade smartlingConnector;
    @Autowired
    private PathEvaluator pathEvaluator;
    @Autowired
    private MetricRegistry metricRegistry;
    @Autowired
    private ApiClientFactory apiClientFactory;
    @Autowired
    private FileOperations fileOperations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ImportResult> importData(TranslationImportRequest translationRequest) throws ServiceException {
        Assert.notNull((Object)translationRequest, (String)"Translation event must not be null");
        logger.info("Translation event handling starting...");
        Timer.Context timerContext = this.metricRegistry.timer(MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{"processingTime"})).time();
        try {
            List<ImportResult> importResults = this.processTranslationImportRequest(translationRequest);
            logger.info("Translation event handling is finished successfully");
            List<ImportResult> list = importResults;
            return list;
        }
        finally {
            timerContext.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ImportResult> processTranslationImportRequest(TranslationImportRequest translationRequest) throws ServiceException {
        ResourcePersistentData resource = this.persistenceService.findBySmartlingUri(translationRequest.getSmartlingUri());
        if (resource != null) {
            Pair<VcsResourceUpdate, Collection<String>> vcsResourceUpdates = this.mapToVcsResourceUpdate(this.filterSupportsDownloadAndLocale(this.pairWithLocales(this.resyncUpdate(translationRequest)), resource), resource);
            Map<String, File> locale2Content = this.downloadContentOrUpdateLastModified(vcsResourceUpdates.getKey(), vcsResourceUpdates.getValue());
            try {
                List<ImportResult> list = this.pushContent(vcsResourceUpdates.getKey(), locale2Content);
                return list;
            }
            finally {
                this.cleanupTemporaryFiles(locale2Content.values());
            }
        }
        return Collections.emptyList();
    }

    private Map<String, File> downloadContentOrUpdateLastModified(VcsResourceUpdate vcsResourceUpdate, Collection<String> locales) throws ServiceException {
        HashMap<String, File> result = new HashMap<String, File>();
        try {
            for (String locale : locales) {
                File content = this.smartlingConnector.download(vcsResourceUpdate, locale);
                if (content != null) {
                    result.put(locale, content);
                    continue;
                }
                this.updateLastModifiedIfPushNotNeeded(vcsResourceUpdate, locale);
            }
            return result;
        }
        catch (Exception e) {
            this.cleanupTemporaryFiles(result.values());
            throw e;
        }
    }

    private Pair<VcsResourceUpdate, Collection<String>> mapToVcsResourceUpdate(Pair<TranslationImportRequest, Collection<String>> importRequestLocalesPair, ResourcePersistentData resourcePersistentData) {
        return ImmutablePair.of(new VcsResourceUpdate(importRequestLocalesPair.getKey(), this.repositoryFactory.getProjectData(resourcePersistentData.getRepositoryKey())), importRequestLocalesPair.getValue());
    }

    private Pair<TranslationImportRequest, Collection<String>> filterSupportsDownloadAndLocale(Pair<TranslationImportRequest, Collection<String>> importRequestLocalesPair, ResourcePersistentData resource) {
        ArrayList<String> supportedLocales = new ArrayList<String>();
        if (ResourceUtils.isSupportsDownload(resource)) {
            for (String locale : importRequestLocalesPair.getValue()) {
                if (!ResourceUtils.isSupportsLocale(resource, locale)) continue;
                supportedLocales.add(locale);
            }
        }
        return ImmutablePair.of(importRequestLocalesPair.getLeft(), supportedLocales);
    }

    private Pair<TranslationImportRequest, Collection<String>> pairWithLocales(TranslationImportRequest translationImportRequest) {
        ArrayList<String> locales = new ArrayList<String>();
        for (String locale : translationImportRequest.getLocales()) {
            locales.add(locale);
        }
        return ImmutablePair.of(translationImportRequest, locales);
    }

    private void updateLastModifiedIfPushNotNeeded(VcsResourceUpdate update, String locale) {
        try {
            this.updateLastModifiedInPersistence(update);
            logger.info("Content has not been pushed, but last modified is updated for fileUri=\"{}\", locale={}", (Object)update.getSmartlingUri(), (Object)locale);
        }
        catch (Exception e) {
            logger.error("Error during updating last modified for fileUri=\"{}\", locale={}", new Object[]{update.getSmartlingUri(), locale, e});
        }
    }

    private List<ImportResult> pushContent(VcsResourceUpdate update, Map<String, File> localeContent) throws ServiceException {
        ArrayList<ImportResult> result = new ArrayList<ImportResult>();
        Map<EvaluationResult, File> evaluationResultContent = this.mapToEvaluationResult(update, localeContent);
        if (evaluationResultContent.size() > 0) {
            RepositoryConnector repository = this.repositoryFactory.getConnector(update.getRepositoryKey());
            try {
                logger.debug("Get repository connector by key");
                repository.resetBranch();
                Map<EvaluationResult, File> changedContent = this.filterChangedTranslatedFiles(repository, evaluationResultContent);
                if (changedContent.size() > 0) {
                    Collection<File> translatedFiles = this.storeFiles(repository, changedContent);
                    Pair<Collection<String>, String> fileRepositoryPathsCommitMessage = this.mapToFilesRepositoryPathsCommitMessage(evaluationResultContent.keySet());
                    Collection<String> filesToCommit = fileRepositoryPathsCommitMessage.getKey();
                    Collection<String> preprocessedFilesToCommit = this.hookExecutor.executePreCommitHook(update.getProjectData(), repository.localPath(), filesToCommit);
                    boolean successfullyCommitted = repository.push(preprocessedFilesToCommit, fileRepositoryPathsCommitMessage.getValue());
                    if (successfullyCommitted) {
                        logger.info("The following translated files have been changed and pushed to the repository:\n{}", (Object)StringUtils.collectionToDelimitedString(translatedFiles, (String)",\n"));
                        result.add(new ImportResult(ImportStatus.OK, update.getResourcePersistentData(), localeContent.keySet(), ResourceStatus.TRANSLATED));
                        this.updateLastModifiedInPersistence(update);
                    } else {
                        logger.error("Commit of the following translated files failed:\n{}", (Object)StringUtils.collectionToDelimitedString(translatedFiles, (String)",\n"));
                    }
                } else {
                    logger.info("Translated files doen't contain actual changes, so no files were committed");
                    this.updateLastModifiedInPersistence(update);
                }
                ArrayList<ImportResult> arrayList = result;
                if (repository != null) {
                    repository.close();
                }
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ServiceException(String.format("Error during pushing content for resource update '%s':", update), e);
                }
            }
        }
        return result;
    }

    private Pair<Collection<String>, String> mapToFilesRepositoryPathsCommitMessage(Set<EvaluationResult> evaluationResults) {
        ArrayList<String> filesRepositoryPath = new ArrayList<String>();
        StringBuilder commitMessageBuilder = new StringBuilder();
        for (EvaluationResult evaluationResult : evaluationResults) {
            String repositoryPath = evaluationResult.getRepositoryPath();
            String commitMessage = evaluationResult.getCommitMessage();
            filesRepositoryPath.add(repositoryPath);
            commitMessageBuilder.append(commitMessage).append("\n");
        }
        return ImmutablePair.of(filesRepositoryPath, StringUtils.trimTrailingWhitespace((String)commitMessageBuilder.toString()));
    }

    private Collection<File> storeFiles(RepositoryConnector repository, Map<EvaluationResult, File> evaluationResultContent) throws ServiceException {
        ArrayList<File> result = new ArrayList<File>();
        for (Map.Entry<EvaluationResult, File> entry : evaluationResultContent.entrySet()) {
            String repositoryPath = entry.getKey().getRepositoryPath();
            File content = entry.getValue();
            File translatedFile = repository.getResource(repositoryPath);
            this.fileOperations.storeBufferedContent(translatedFile, content);
            result.add(translatedFile);
            logger.info("Translated content is stored to fileUri=\"{}\"", (Object)translatedFile.getPath());
        }
        return result;
    }

    private Map<EvaluationResult, File> mapToEvaluationResult(VcsResourceUpdate update, Map<String, File> localeContent) throws ServiceException {
        HashMap<EvaluationResult, File> result = new HashMap<EvaluationResult, File>();
        String smartlingUri = update.getSmartlingUri();
        ResourcePersistentData resourcePersistentData = update.getResourcePersistentData();
        for (Map.Entry<String, File> entry : localeContent.entrySet()) {
            EvaluationResult evaluationResult = this.getEvaluationResult(smartlingUri, entry.getKey(), resourcePersistentData);
            result.put(evaluationResult, entry.getValue());
        }
        return result;
    }

    private Map<EvaluationResult, File> filterChangedTranslatedFiles(RepositoryConnector repository, Map<EvaluationResult, File> evaluationResultContent) throws ServiceException {
        HashMap<EvaluationResult, File> result = new HashMap<EvaluationResult, File>();
        ArrayList<String> acceptedPaths = new ArrayList<String>();
        ArrayList<String> declinedPaths = new ArrayList<String>();
        for (Map.Entry<EvaluationResult, File> entry : evaluationResultContent.entrySet()) {
            File bufferedContent;
            EvaluationResult evaluationResult = entry.getKey();
            String repositoryFilePath = evaluationResult.getRepositoryPath();
            File repositoryFile = repository.getResource(repositoryFilePath);
            if (this.fileOperations.contentDiffers(repositoryFile, bufferedContent = entry.getValue())) {
                result.put(evaluationResult, bufferedContent);
                acceptedPaths.add(repositoryFilePath);
                continue;
            }
            declinedPaths.add(repositoryFilePath);
        }
        if (CollectionUtils.isNotEmpty(declinedPaths)) {
            logger.warn("{} of {} translated files were changed in smartling but there are no actual changes in content:\n{}", new Object[]{declinedPaths.size(), evaluationResultContent.size(), StringUtils.collectionToDelimitedString(declinedPaths, (String)",\n")});
        }
        if (CollectionUtils.isNotEmpty(acceptedPaths)) {
            logger.debug("{} of {} translated files with changes that should be committed:\n{}", new Object[]{acceptedPaths.size(), evaluationResultContent.size(), StringUtils.collectionToDelimitedString(acceptedPaths, (String)",\n")});
        }
        return result;
    }

    private TranslationImportRequest resyncUpdate(TranslationImportRequest importRequest) throws ServiceException {
        try {
            Date lastModified = importRequest.getResourceData().getLastModified();
            String smartlingUri = importRequest.getSmartlingUri();
            RepositoryKey repositoryKey = importRequest.getRepositoryKey();
            FilesApiClient smartlingFAPI = this.apiClientFactory.getFileApi(repositoryKey);
            GetFileLastModifiedPTO fileLastModifiedPTO = new GetFileLastModifiedPTO(smartlingUri, DateFormatter.format(lastModified));
            List<FileLocaleLastModifiedPTO> responseLastModified = smartlingFAPI.getLastModified(fileLastModifiedPTO);
            ArrayList<String> locales = new ArrayList<String>();
            for (FileLocaleLastModifiedPTO localeLastModified : responseLastModified) {
                if (lastModified == null || lastModified.before(localeLastModified.getLastModified())) {
                    lastModified = localeLastModified.getLastModified();
                }
                if (!ResourceUtils.isSupportsLocale(importRequest.getResourceData(), localeLastModified.getLocaleId())) continue;
                locales.add(localeLastModified.getLocaleId());
            }
            importRequest.getResourceData().setLastModified(lastModified);
            return new TranslationImportRequest(importRequest.getResourceData(), locales, importRequest.isForce());
        }
        catch (Exception e) {
            throw new ServiceException(String.format("Error during getting last modified for resource update '%s':", importRequest), e);
        }
    }

    private void updateLastModifiedInPersistence(VcsResourceUpdate update) {
        this.persistenceService.updateLastModified(update.getSmartlingUri(), update.getLastModified());
        logger.info("Last modified set to {} for fileUri=\"{}\"", (Object)update.getLastModified(), (Object)update.getSmartlingUri());
    }

    private EvaluationResult getEvaluationResult(String smartlingUri, String localeId, ResourcePersistentData resource) throws ServiceException {
        logger.info("Translated content is received for fileUri=\"{}\", locale={}", (Object)smartlingUri, (Object)localeId);
        EvaluationResult evaluationResult = this.pathEvaluator.evaluatePathExpression(resource.getRepositoryPath(), resource.getLocalesMapping().get(localeId), resource);
        logger.info("The sourceFilePath=\"{}\" and locale={} is evaluated targetFilePath=\"{}\"", new Object[]{resource.getRepositoryPath(), localeId, evaluationResult.getRepositoryPath()});
        return evaluationResult;
    }

    private void cleanupTemporaryFiles(Collection<File> files) {
        files.forEach(File::delete);
    }
}

