/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.importer;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.smartling.api.v2.response.Error;
import com.smartling.repoconnector.model.ImportResult;
import com.smartling.repoconnector.model.ImportStatus;
import com.smartling.repoconnector.model.ProjectData;
import com.smartling.repoconnector.model.PushImportRequest;
import com.smartling.repoconnector.model.RepositoryResourceChange;
import com.smartling.repoconnector.model.RepositoryResourcesSet;
import com.smartling.repoconnector.model.ResourceStatus;
import com.smartling.repoconnector.model.SmartlingResourceUpdate;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.exception.SmartlingRestApiException;
import com.smartling.repoconnector.services.exception.UnrecoverableSmartlingRestApiException;
import com.smartling.repoconnector.services.hooks.HookExecutor;
import com.smartling.repoconnector.services.importer.AbstractImporter;
import com.smartling.repoconnector.services.importer.Importer;
import com.smartling.repoconnector.services.persistence.RevisionPersistenceService;
import com.smartling.repoconnector.services.vcs.RepositoryConnector;
import com.smartling.repoconnector.services.vcs.resources.ResourcesConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class Vcs2SmartlingImporterImpl
extends AbstractImporter
implements Importer<PushImportRequest> {
    private static Logger logger = LoggerFactory.getLogger(Vcs2SmartlingImporterImpl.class);
    @Autowired
    private RevisionPersistenceService persistenceService;
    @Autowired
    private HookExecutor hookExecutor;

    @Override
    public List<ImportResult> importData(PushImportRequest push) throws ServiceException {
        Assert.notNull((Object)push, (String)"Push event must not be null");
        logger.info("Push (files to Smartling) event handling starting...");
        Timer.Context timerContext = this.getMetricRegistry().timer(MetricRegistry.name((String)this.getClass().getSimpleName(), (String[])new String[]{"processingTime"})).time();
        try {
            RepositoryConnector repository = this.getRepositoryConnector(push.getRepositoryKey());
            try {
                logger.debug("Get repository connector by key");
                List<ImportResult> list = this.handlePushEvent(push, repository);
                if (repository != null) {
                    repository.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ServiceException(String.format("Error during importing data '%s'", push), e);
                }
            }
        }
        finally {
            timerContext.stop();
        }
    }

    private List<ImportResult> handlePushEvent(PushImportRequest push, RepositoryConnector repository) throws ServiceException {
        List<ImportResult> result;
        String handledRevision = this.persistenceService.lastRevision(push.getRepositoryKey());
        if (this.requestContainsUnprocessedRevision(push, repository, handledRevision)) {
            result = this.processNewRevision(push, repository, handledRevision);
        } else {
            logger.info("Revision {} is before processed revision {}", (Object)push.getRevision(), (Object)handledRevision);
            result = Collections.emptyList();
        }
        logger.info("Push event handling is finished successfully");
        return result;
    }

    private boolean requestContainsUnprocessedRevision(PushImportRequest push, RepositoryConnector repository, String handledRevision) throws ServiceException {
        return !repository.isRevisionBefore(handledRevision, push.getRevision());
    }

    private List<ImportResult> processNewRevision(PushImportRequest push, RepositoryConnector repository, String handledRevision) throws ServiceException {
        logger.info("Starting processing revisions from {} to {}", (Object)handledRevision, (Object)push.getRevision());
        repository.resetBranch();
        logger.info("Repository is updated to head");
        ProjectData projectData = this.getProjectData(push.getRepositoryKey());
        String configName = this.getResourcesConfig(repository, push.getResourcesConfig(), projectData.getResourcesConfig());
        if (null == configName) {
            return this.getResultUsingServerConfig(push, repository, handledRevision, projectData);
        }
        return this.getResultUsingRepositoryConfig(push, repository, handledRevision, projectData, configName);
    }

    private List<ImportResult> getResultUsingRepositoryConfig(PushImportRequest push, RepositoryConnector repository, String handledRevision, ProjectData projectData, String configName) throws ServiceException {
        logger.info("Repository resources configuration file {}", (Object)configName);
        ResourcesConfiguration config = this.getBean(ResourcesConfiguration.class, repository.getResource(configName));
        List<RepositoryResourceChange> changes = repository.getModifiedResources(handledRevision, configName);
        if (!changes.isEmpty()) {
            logger.info("Repository resources configuration file {} is changed from previous state", (Object)configName);
            handledRevision = null;
        }
        return this.processRevisions(push, repository, handledRevision, projectData, config);
    }

    private List<ImportResult> getResultUsingServerConfig(PushImportRequest push, RepositoryConnector repository, String handledRevision, ProjectData projectData) throws ServiceException {
        File tmp;
        ResourcesConfiguration config = null;
        String configName = this.getResourcesConfig(null, projectData.getServerResourcesConfig(), FilenameUtils.concat(this.getConfigurationDirectory(), projectData.getServerResourcesConfig()));
        if (StringUtils.isNotBlank(configName) && (tmp = this.getServerFile(configName)).exists()) {
            logger.info("Server resources configuration file {}", (Object)configName);
            config = this.getBean(ResourcesConfiguration.class, new File(configName));
            Date lastUpdate = this.persistenceService.lastUpdated(push.getRepositoryKey());
            if (null == lastUpdate || tmp.lastModified() > lastUpdate.getTime()) {
                logger.info("Server resources configuration file {} is changed from previous state", (Object)configName);
                handledRevision = null;
            }
        }
        return this.processRevisions(push, repository, handledRevision, projectData, config);
    }

    private List<ImportResult> processRevisions(PushImportRequest push, RepositoryConnector repository, String handledRevision, ProjectData projectData, ResourcesConfiguration config) throws ServiceException {
        List<ImportResult> result = Collections.emptyList();
        if (null != config) {
            result = this.uploadResources(push, repository, handledRevision, projectData, config);
        } else {
            logger.warn("Resource configuration not found! Nothing is uploaded to Smartling");
        }
        String topRevison = repository.getTopRevision();
        if (this.containsRecoverableError(result)) {
            logger.warn("Revisions from {} to {} was processed with errors. Will try again next time", (Object)handledRevision, (Object)topRevison);
        } else {
            this.persistenceService.save(push.getRepositoryKey(), push.getProjectId(), topRevison);
            logger.info("Revisions from {} to {} was processed successfully", (Object)handledRevision, (Object)topRevison);
        }
        return result.stream().filter(r -> r.getImportStatus() == ImportStatus.OK).collect(Collectors.toList());
    }

    private boolean containsRecoverableError(List<ImportResult> result) {
        return result.stream().anyMatch(r -> r.getImportStatus() == ImportStatus.RECOVERABLE);
    }

    private List<ImportResult> uploadResources(PushImportRequest push, RepositoryConnector repository, String handledRevision, ProjectData projectData, ResourcesConfiguration config) throws ServiceException {
        ArrayList<ImportResult> result = new ArrayList<ImportResult>();
        List<RepositoryResourceChange> changes = repository.getModifiedResources(handledRevision, null);
        logger.info("There are {} changes detected in repository", (Object)changes.size());
        List<RepositoryResourceChange> preprocessedChanges = this.hookExecutor.executePostCheckoutHook(projectData, repository.localPath(), changes);
        logger.info("There are {} preprocessed resources must be uploaded to smartling", (Object)preprocessedChanges.size());
        List<SmartlingResourceUpdate> toUpdate = this.findResourcesToUpdate(push, preprocessedChanges, config, projectData);
        logger.info("There are {} resources must be uploaded to smartling", (Object)toUpdate.size());
        for (SmartlingResourceUpdate resource : toUpdate) {
            try {
                ImportResult resourceResult = this.getSmartlingConnector().upload(resource, null == resource.getRepositoryPath() ? null : repository.getResource(resource.getRepositoryPath()));
                result.add(resourceResult);
            }
            catch (SmartlingRestApiException e) {
                logger.error("Uploading resource to Smartling failed: requestId={}, status={}, changeType='{}', resourceType='{}', path='{}', previousPath='{}' : \"{}\"", new Object[]{e.getRequestId(), e.getStatusCode(), resource.getChangeType(), resource.getResourceType(), resource.getRepositoryPath(), resource.getPreviousRepositoryPath(), this.getUserFriendlyMessage(e), e});
                ImportStatus status = e instanceof UnrecoverableSmartlingRestApiException ? ImportStatus.UNRECOVERABLE : ImportStatus.RECOVERABLE;
                ImportResult resourceResult = new ImportResult(status, resource, null, ResourceStatus.IN_PROGRESS);
                result.add(resourceResult);
            }
            catch (Exception e) {
                logger.error("Uploading resource to Smartling failed: changeType='{}', resourceType='{}', path='{}', previousPath='{}'", new Object[]{resource.getChangeType(), resource.getResourceType(), resource.getRepositoryPath(), resource.getPreviousRepositoryPath(), e});
                ImportResult resourceResult = new ImportResult(ImportStatus.RECOVERABLE, resource, null, ResourceStatus.IN_PROGRESS, Collections.singletonList(e.getMessage()));
                result.add(resourceResult);
            }
        }
        return result;
    }

    private String getUserFriendlyMessage(SmartlingRestApiException ex) {
        if (ex.getErrors() != null) {
            return ex.getErrors().stream().map(Error::getMessage).collect(Collectors.joining(","));
        }
        return ex.getMessage();
    }

    protected File getServerFile(String name) {
        return new File(name);
    }

    private List<SmartlingResourceUpdate> findResourcesToUpdate(PushImportRequest push, List<RepositoryResourceChange> changes, ResourcesConfiguration config, ProjectData projectData) {
        ArrayList<SmartlingResourceUpdate> toUpdate = new ArrayList<SmartlingResourceUpdate>();
        boolean isDebugLogging = logger.isDebugEnabled();
        logger.debug("There are {} resources set(s) available", (Object)config.getResourcesSets().size());
        block0: for (RepositoryResourceChange change : changes) {
            for (RepositoryResourcesSet set : config.getResourcesSets()) {
                if (!this.getPathEvaluator().matchPath(change.getActualPath(), set) && !this.getPathEvaluator().matchPath(change.getPreviousPath(), set)) continue;
                toUpdate.add(new SmartlingResourceUpdate(push, change, set, projectData));
                if (!isDebugLogging) continue block0;
                logger.debug("Resource {} old name {} is suggested to upload to smartling by regex {}", new Object[]{change.getActualPath(), change.getOldPath(), set.getPathRegex()});
                continue block0;
            }
        }
        return toUpdate;
    }

    private String getResourcesConfig(RepositoryConnector repository, String ... fileNames) {
        String resourcesConfig = null;
        for (String fileName : fileNames) {
            File file;
            if (!StringUtils.isNotBlank(fileName)) continue;
            File file2 = file = null != repository ? repository.getResource(fileName) : this.getServerFile(fileName);
            if (null == file || !file.exists() || !file.isFile()) continue;
            resourcesConfig = fileName;
            break;
        }
        return resourcesConfig;
    }
}

