/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.importer.pathevaluator;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import com.smartling.repoconnector.model.EvaluationResult;
import com.smartling.repoconnector.model.TranslationEvaluationData;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.importer.pathevaluator.File;
import com.smartling.repoconnector.services.importer.pathevaluator.PathEvaluator;
import com.smartling.repoconnector.services.utils.RepoFileUtils;
import groovy.lang.GroovyShell;
import groovy.lang.Writable;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GroovyNamedGroupPathEvaluator
implements PathEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(GroovyNamedGroupPathEvaluator.class);
    private static final String TRANSLATED_FILE_CONTEXT_ENTRY = "translatedFile";
    private static final String ORIGINAL_FILE_CONTEXT_ENTRY = "originalFile";
    private static final String LOCALE_CONTEXT_ENTRY = "locale";
    @Value(value="${smartling.defaultCommitMessage}")
    private String defaultCommitMessage;

    @Override
    public EvaluationResult evaluatePathExpression(String originalRepositoryPath, String localeId, TranslationEvaluationData evaluationData) throws ServiceException {
        try {
            File originalFile = new File(originalRepositoryPath);
            HashMap<String, Object> context = new HashMap<String, Object>();
            Matcher matcher = this.getMatcher(evaluationData.getPathRegex(), originalRepositoryPath);
            if (matcher != null) {
                context.putAll(matcher.namedGroups());
            }
            context.put(LOCALE_CONTEXT_ENTRY, localeId);
            context.put(ORIGINAL_FILE_CONTEXT_ENTRY, originalFile);
            String path = this.evaluate(evaluationData.getPathExpression(), context);
            context.put(TRANSLATED_FILE_CONTEXT_ENTRY, new File(path));
            String messageExpression = evaluationData.getCommitMessage();
            if (StringUtils.isBlank(messageExpression)) {
                messageExpression = this.defaultCommitMessage;
            }
            String commitMessage = this.evaluate(messageExpression, context);
            String normalizedPath = RepoFileUtils.collapseDoubleSlashes(RepoFileUtils.removeLeadSlash(path));
            return new EvaluationResult(normalizedPath, commitMessage);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public boolean matchPath(String originalRepositoryPath, TranslationEvaluationData evaluationData) {
        boolean result;
        Matcher matcher = this.getMatcher(evaluationData.getPathRegex(), originalRepositoryPath);
        boolean bl = result = null == matcher ? false : matcher.matches();
        if (!result) {
            logger.trace("There is no match for '{}' and regex '{}'", (Object)originalRepositoryPath, (Object)evaluationData.getPathRegex());
        } else {
            logger.trace("There is match for '{}' and regex '{}'", (Object)originalRepositoryPath, (Object)evaluationData.getPathRegex());
        }
        return result;
    }

    private String evaluate(String expression, Map<String, Object> context) throws IOException, ClassNotFoundException {
        CompilerConfiguration config = new CompilerConfiguration();
        config.addCompilationCustomizers(new CompilationCustomizer[]{this.getSecureCustomizer()});
        GroovyShell shell = new GroovyShell(config);
        SimpleTemplateEngine templateEngine = new SimpleTemplateEngine(shell);
        Template templateObject = templateEngine.createTemplate(expression);
        Writable result = templateObject.make(context);
        StringWriter writer = new StringWriter();
        result.writeTo((Writer)writer);
        return writer.toString();
    }

    private Matcher getMatcher(String regex, String path) {
        Matcher matcher = null;
        if (StringUtils.isNotBlank(path) && StringUtils.isNotBlank(regex)) {
            matcher = Pattern.compile((String)RepoFileUtils.removeLeadSlash(regex)).matcher((CharSequence)RepoFileUtils.removeLeadSlash(path));
        }
        return matcher;
    }

    private SecureASTCustomizer getSecureCustomizer() {
        SecureASTCustomizer secure = new SecureASTCustomizer();
        secure.setClosuresAllowed(false);
        secure.setMethodDefinitionAllowed(false);
        secure.setImportsWhitelist(Collections.emptyList());
        secure.setStaticImportsWhitelist(Collections.emptyList());
        secure.setStaticStarImportsWhitelist(Collections.emptyList());
        secure.setExpressionsBlacklist(Arrays.asList(ConstructorCallExpression.class));
        secure.setReceiversClassesWhiteList(Arrays.asList(Object.class, String.class, File.class));
        return secure;
    }
}

