/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.integration;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.smartling.api.files.v2.FilesApi;
import com.smartling.api.files.v2.FilesApiFactory;
import com.smartling.api.locales.v2.LocalesApi;
import com.smartling.api.locales.v2.LocalesApiFactory;
import com.smartling.api.v2.authentication.AuthenticationApiFactory;
import com.smartling.api.v2.client.ApiFactory;
import com.smartling.api.v2.client.ClientConfiguration;
import com.smartling.api.v2.client.ClientFactory;
import com.smartling.api.v2.client.DefaultClientConfiguration;
import com.smartling.api.v2.client.auth.Authenticator;
import com.smartling.api.v2.client.auth.AuthorizationRequestFilter;
import com.smartling.api.v2.client.auth.BearerAuthSecretFilter;
import com.smartling.api.v2.client.useragent.LibNameVersionHolder;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.services.CredentialsInvalidException;
import com.smartling.repoconnector.services.integration.FilesApiClient;
import com.smartling.repoconnector.services.integration.HttpClientConfigurationFactory;
import com.smartling.repoconnector.services.vcs.data.AuthenticationConfig;
import com.smartling.repoconnector.services.vcs.data.ProjectAuthenticationDataProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Service;

@Service
public class ApiClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiClientFactory.class);
    private final String projectIdPattern;
    private final String userIdentifierPattern;
    private final String tokenSecretPattern;
    private final String smartlingApiHost;
    private final ProjectAuthenticationDataProvider projectAuthProvider;
    private final Cache<String, Authenticator> authenticatorCache;
    private final ClientFactory clientFactory;
    private final FilesApiFactory filesApiFactory;
    private final LocalesApiFactory localesApiFactory;
    private final ClientConfiguration configuration;
    private final RetryTemplate retryTemplate;

    @Autowired
    public ApiClientFactory(ProjectAuthenticationDataProvider projectAuthProvider, LibNameVersionHolder libNameVersionHolder, HttpClientConfigurationFactory httpClientConfigurationFactory, RetryTemplate retryTemplate, @Value(value="${smartling.apiHost:api.smartling.com}") String smartlingApiHost, @Value(value="${smartling.projectIdPattern}") String projectIdPattern, @Value(value="${smartling.userIdentifierPattern}") String userIdentifierPattern, @Value(value="${smartling.tokenSecretPattern}") String tokenSecretPattern, @Value(value="${smartling.tokenCacheExpirationHours:4}") Long tokenCacheExpirationHours) {
        this.smartlingApiHost = smartlingApiHost;
        this.projectAuthProvider = projectAuthProvider;
        this.projectIdPattern = projectIdPattern;
        this.userIdentifierPattern = userIdentifierPattern;
        this.tokenSecretPattern = tokenSecretPattern;
        this.retryTemplate = retryTemplate;
        this.authenticatorCache = CacheBuilder.newBuilder().expireAfterWrite(tokenCacheExpirationHours.longValue(), TimeUnit.HOURS).build();
        this.clientFactory = new ClientFactory();
        this.filesApiFactory = new FilesApiFactory(this.clientFactory);
        this.localesApiFactory = new LocalesApiFactory(this.clientFactory);
        this.configuration = DefaultClientConfiguration.builder().baseUrl(this.apiURL()).libNameVersionHolder(libNameVersionHolder).httpClientConfiguration(httpClientConfigurationFactory.createHttpClientConfiguration()).build();
    }

    public LocalesApi getLocalesApi(AuthenticationConfig authData) throws CredentialsInvalidException {
        return (LocalesApi)this.getApi((ApiFactory)this.localesApiFactory, authData);
    }

    public FilesApiClient getFileApi(RepositoryKey repositoryKey) throws CredentialsInvalidException {
        return this.getFileApi(this.projectAuthProvider.getProjectAuthenticationData(repositoryKey));
    }

    public FilesApiClient getFileApi(AuthenticationConfig authData) throws CredentialsInvalidException {
        return new FilesApiClient(this.retryTemplate, (FilesApi)this.getApi((ApiFactory)this.filesApiFactory, authData), authData.getProjectId());
    }

    private <T> T getApi(ApiFactory<T> factory, AuthenticationConfig authData) throws CredentialsInvalidException {
        if (null == authData) {
            throw new CredentialsInvalidException("Project credentials are not provided");
        }
        if (StringUtils.isBlank(authData.getProjectId()) || StringUtils.isBlank(authData.getUserIdentifier()) || StringUtils.isBlank(authData.getTokenSecret()) || !authData.getProjectId().matches(this.projectIdPattern) || !authData.getUserIdentifier().matches(this.userIdentifierPattern) || !authData.getTokenSecret().matches(this.tokenSecretPattern)) {
            throw new CredentialsInvalidException("Bad project credentials");
        }
        Authenticator authenticator = this.getAuthenticator(authData.getUserIdentifier(), authData.getTokenSecret());
        BearerAuthSecretFilter bearerAuthSecretFilter = new BearerAuthSecretFilter(authenticator);
        return (T)factory.buildApi((AuthorizationRequestFilter)bearerAuthSecretFilter, this.configuration);
    }

    private Authenticator createAuthenticator(String userId, String tokenSecret) {
        return new Authenticator(userId, tokenSecret, new AuthenticationApiFactory(this.clientFactory).buildApi(this.configuration));
    }

    private Authenticator getAuthenticator(String userId, String tokenSecret) {
        try {
            return (Authenticator)this.authenticatorCache.get((Object)userId, () -> this.createAuthenticator(userId, tokenSecret));
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to obtain token provider from cache by key {}", (Object)userId, (Object)e);
            return this.createAuthenticator(userId, tokenSecret);
        }
    }

    private URL apiURL() {
        try {
            return new URL("https://" + this.smartlingApiHost);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Can't find Api Gateway on Eureka", e);
        }
    }
}

