/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.integration;

import com.smartling.api.files.v2.FilesApi;
import com.smartling.api.files.v2.pto.DeleteFilePTO;
import com.smartling.api.files.v2.pto.DownloadTranslationPTO;
import com.smartling.api.files.v2.pto.FileItemPTO;
import com.smartling.api.files.v2.pto.FileLocaleLastModifiedPTO;
import com.smartling.api.files.v2.pto.FileLocaleStatusResponse;
import com.smartling.api.files.v2.pto.GetFileLastModifiedPTO;
import com.smartling.api.files.v2.pto.GetFilesListPTO;
import com.smartling.api.files.v2.pto.RenameFilePto;
import com.smartling.api.files.v2.pto.UploadFilePTO;
import com.smartling.api.files.v2.pto.UploadFileResponse;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import com.smartling.api.v2.response.ResponseCode;
import com.smartling.repoconnector.services.exception.RecoverableSmartlingRestApiException;
import com.smartling.repoconnector.services.exception.SmartlingRestApiException;
import com.smartling.repoconnector.services.exception.UnrecoverableSmartlingRestApiException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.retry.support.RetryTemplate;

public class FilesApiClient {
    private final FilesApi filesApi;
    private final String projectId;
    private final RetryTemplate retryTemplate;

    public FilesApiClient(RetryTemplate retryTemplate, FilesApi filesApi, String projectId) {
        this.filesApi = filesApi;
        this.projectId = projectId;
        this.retryTemplate = retryTemplate;
    }

    public void deleteFile(String smartlingUri) throws SmartlingRestApiException {
        this.execute("deleteFile", () -> this.filesApi.deleteFile(this.projectId, new DeleteFilePTO(smartlingUri)), e -> FilesApiClient.wrap(e, String.format("Can't delete fileUri=%s", smartlingUri)));
    }

    public FileLocaleLastModifiedPTO getFileLocaleLastModified(String locale, GetFileLastModifiedPTO lastModifiedPTO) throws SmartlingRestApiException {
        return this.execute("getFileLocaleLastModified", () -> this.filesApi.getFileLocaleLastModified(this.projectId, locale, lastModifiedPTO), e -> FilesApiClient.wrap(e, String.format("Can't get last modified fileUri=%s, after=%s, locale=%s", lastModifiedPTO.getFileUri(), lastModifiedPTO.getLastModifiedAfter(), locale)));
    }

    public List<FileLocaleLastModifiedPTO> getLastModified(GetFileLastModifiedPTO lastModifiedPTO) throws SmartlingRestApiException {
        return this.execute("getLastModified", () -> this.filesApi.getFileLastModified(this.projectId, lastModifiedPTO).getItems(), e -> FilesApiClient.wrap(e, String.format("Can't get last modified fileUri=%s, after=%s", lastModifiedPTO.getFileUri(), lastModifiedPTO.getLastModifiedAfter())));
    }

    public FileLocaleStatusResponse getFileLocaleStatus(String fileUri, String locale) throws SmartlingRestApiException {
        return this.execute("getFileLocaleStatus", () -> this.filesApi.getFileLocaleStatus(this.projectId, locale, fileUri), e -> FilesApiClient.wrap(e, String.format("Can't get file locale status fileUri=%s, locale=%s", fileUri, locale)));
    }

    public InputStream getFile(String locale, DownloadTranslationPTO downloadTranslationPTO) throws SmartlingRestApiException {
        return this.execute("getFile", () -> this.filesApi.downloadTranslatedFile(this.projectId, locale, downloadTranslationPTO), e -> FilesApiClient.wrap(e, String.format("Can't download translation for fileUri=%s, locale=%s", downloadTranslationPTO.getFileUri(), locale)));
    }

    public List<FileItemPTO> getFilesList(GetFilesListPTO filesListPTO) throws SmartlingRestApiException {
        return this.execute("getFilesList", () -> this.filesApi.getFilesList(this.projectId, filesListPTO).getItems(), e -> FilesApiClient.wrap(e, String.format("Can't get files list with limit=%d, offset=%d", filesListPTO.getLimit(), filesListPTO.getOffset())));
    }

    public void renameFile(RenameFilePto renameFilePto) throws SmartlingRestApiException {
        this.execute("renameFile", () -> this.filesApi.renameFile(this.projectId, renameFilePto), e -> FilesApiClient.wrap(e, String.format("Can't rename file. fileUri=%s, newFileUri=%s", renameFilePto.getFileUri(), renameFilePto.getNewFileUri())));
    }

    public UploadFileResponse uploadFile(UploadFilePTO uploadFilePTO) throws SmartlingRestApiException {
        return this.execute("uploadFile", () -> this.filesApi.uploadFile(this.projectId, uploadFilePTO), e -> FilesApiClient.wrap(e, String.format("Can't upload with with fileUri=%s", uploadFilePTO.getFileUri())));
    }

    private static SmartlingRestApiException wrap(RestApiRuntimeException ex, String exceptionMessage) {
        if (ex.getResponseCode() == ResponseCode.VALIDATION_ERROR) {
            return new UnrecoverableSmartlingRestApiException(exceptionMessage, ex);
        }
        return new RecoverableSmartlingRestApiException(exceptionMessage, ex);
    }

    private <T> T execute(String methodName, Supplier<T> supplier, Function<RestApiRuntimeException, SmartlingRestApiException> exceptionSupplier) throws SmartlingRestApiException {
        try {
            return (T)this.retryTemplate.execute(retryContext -> {
                retryContext.setAttribute("context.name", (Object)("FilesApiClient." + methodName));
                return supplier.get();
            });
        }
        catch (RestApiRuntimeException e) {
            throw exceptionSupplier.apply(e);
        }
    }
}

