/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.integration;

import com.smartling.api.v2.client.HttpClientConfiguration;
import com.smartling.repoconnector.ProxyUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HttpClientConfigurationFactory {
    private final Integer connectionRequestTimeout;
    private final Integer connectionTimeout;
    private final Integer socketTimeout;

    public HttpClientConfigurationFactory(@Value(value="${smartling.api.connectionRequestTimeout:60000}") Integer connectionRequestTimeout, @Value(value="${smartling.api.connectionTimeout:10000}") Integer connectionTimeout, @Value(value="${smartling.api.socketTimeout:60000}") Integer socketTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
    }

    public HttpClientConfiguration createHttpClientConfiguration() {
        HttpClientConfiguration httpClientConfiguration = new HttpClientConfiguration();
        httpClientConfiguration.setConnectionRequestTimeout(this.connectionRequestTimeout.intValue());
        httpClientConfiguration.setConnectionTimeout(this.connectionTimeout.intValue());
        httpClientConfiguration.setSocketTimeout(this.socketTimeout.intValue());
        if (ProxyUtils.isProxyUsed()) {
            httpClientConfiguration.setProxyHost(ProxyUtils.getProxyHost());
            httpClientConfiguration.setProxyPort(ProxyUtils.getProxyPort().intValue());
            String proxyUser = ProxyUtils.getProxyUser();
            String proxyPassword = ProxyUtils.getProxyPassword();
            if (StringUtils.isNotBlank(proxyPassword) && StringUtils.isNotBlank(proxyUser)) {
                httpClientConfiguration.setProxyPassword(proxyPassword);
                httpClientConfiguration.setProxyUser(proxyUser);
            }
        }
        return httpClientConfiguration;
    }
}

