/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.integration.retry;

import com.smartling.api.v2.client.exception.client.ResourceLockedErrorException;
import com.smartling.api.v2.client.exception.client.TooManyRequestsException;
import com.smartling.api.v2.client.exception.server.ServerApiException;
import com.smartling.repoconnector.services.exception.RecoverableSmartlingRestApiException;
import com.smartling.repoconnector.services.integration.retry.RetryLogger;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.annotation.RetryConfiguration;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@Import(value={RetryConfiguration.class})
public class RetryConfig {
    @Bean
    public BinaryExceptionClassifier defaultSmartlingSdkExceptionClassifier() {
        HashMap<Class<RecoverableSmartlingRestApiException>, Boolean> typeMap = new HashMap<Class<RecoverableSmartlingRestApiException>, Boolean>();
        typeMap.put(ResourceLockedErrorException.class, true);
        typeMap.put(TooManyRequestsException.class, true);
        typeMap.put(ServerApiException.class, true);
        typeMap.put(SocketTimeoutException.class, true);
        typeMap.put(RecoverableSmartlingRestApiException.class, true);
        return new BinaryExceptionClassifier(typeMap, false, true);
    }

    @Bean
    public RetryTemplate smartlingSdkRetryTemplate(@Value(value="${smartling.retry.maxRetryAttempts:1}") Integer maxRetryAttempts, @Value(value="${smartling.retry.retryMinDelay:1000}") Long retryMinDelay, @Value(value="${smartling.retry.retryMaxDelay:10000}") Long retryMaxDelay, @Value(value="${smartling.retry.delayMultiplier:2.0}") Double delayMultiplier, BinaryExceptionClassifier defaultSmartlingSdkExceptionClassifier) {
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(maxRetryAttempts + 1, defaultSmartlingSdkExceptionClassifier);
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setMultiplier(delayMultiplier.doubleValue());
        backOffPolicy.setInitialInterval(retryMinDelay.longValue());
        backOffPolicy.setMaxInterval(retryMaxDelay.longValue());
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        retryTemplate.registerListener((RetryListener)new RetryLogger());
        return retryTemplate;
    }
}

