/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.integration.retry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;

public class RetryLogger
implements RetryListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryLogger.class);

    public <T, E extends Throwable> boolean open(RetryContext retryContext, RetryCallback<T, E> retryCallback) {
        return true;
    }

    public <T, E extends Throwable> void close(RetryContext retryContext, RetryCallback<T, E> retryCallback, Throwable throwable) {
        if (retryContext.getRetryCount() > 1) {
            LOGGER.warn("Failed to retry method {} as maxRetryCount={} reached", retryContext.getAttribute("context.name"), (Object)(retryContext.getRetryCount() - 1));
        }
    }

    public <T, E extends Throwable> void onError(RetryContext retryContext, RetryCallback<T, E> retryCallback, Throwable throwable) {
        LOGGER.info("Retryable method {} threw a {} exception: {}", new Object[]{retryContext.getAttribute("context.name"), this.getRetryCount(retryContext), throwable.getMessage()});
    }

    private String getRetryCount(RetryContext retryContext) {
        int retryCount = retryContext.getRetryCount();
        return retryCount + this.getRetryCountSuffix(retryCount);
    }

    private String getRetryCountSuffix(int retryCount) {
        if (retryCount == 1) {
            return "st";
        }
        if (retryCount == 2) {
            return "nd";
        }
        if (retryCount == 3) {
            return "rd";
        }
        return "th";
    }
}

