/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.integration.uploader;

import com.smartling.api.files.v2.pto.DownloadTranslationPTO;
import com.smartling.api.files.v2.pto.FileLocaleLastModifiedPTO;
import com.smartling.api.files.v2.pto.FileLocaleStatusResponse;
import com.smartling.api.files.v2.pto.FileType;
import com.smartling.api.files.v2.pto.GetFileLastModifiedPTO;
import com.smartling.api.files.v2.pto.GetFilesListPTO;
import com.smartling.api.files.v2.pto.RenameFilePto;
import com.smartling.api.files.v2.pto.UploadFilePTO;
import com.smartling.api.files.v2.pto.UploadFileResponse;
import com.smartling.repoconnector.model.ChangeType;
import com.smartling.repoconnector.model.ImportResult;
import com.smartling.repoconnector.model.ImportStatus;
import com.smartling.repoconnector.model.ResourcePersistentData;
import com.smartling.repoconnector.model.ResourceStatus;
import com.smartling.repoconnector.model.RetrievalTriggerType;
import com.smartling.repoconnector.model.SmartlingResourceUpdate;
import com.smartling.repoconnector.model.VcsResourceUpdate;
import com.smartling.repoconnector.services.ConfigurationException;
import com.smartling.repoconnector.services.CredentialsInvalidException;
import com.smartling.repoconnector.services.DateFormatter;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.exception.SmartlingRestApiException;
import com.smartling.repoconnector.services.integration.ApiClientFactory;
import com.smartling.repoconnector.services.integration.FilesApiClient;
import com.smartling.repoconnector.services.integration.uploader.SmartlingApiFacade;
import com.smartling.repoconnector.services.persistence.ResourcePersistenceService;
import com.smartling.repoconnector.services.utils.FileOperations;
import com.smartling.repoconnector.services.utils.RepoFileUtils;
import com.smartling.repoconnector.services.utils.ResourceUtils;
import com.smartling.repoconnector.services.vcs.data.AuthenticationConfig;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SmartlingApiFacadeImpl
implements SmartlingApiFacade {
    static final String SMARTLING_FILE_URI_AS_NAMESPACE_DIRECTIVE = "smartling.file_uri_as_namespace";
    static final String SMARTLING_NAMESPACE_DIRECTIVE = "smartling.namespace";
    private static final Logger logger = LoggerFactory.getLogger(SmartlingApiFacadeImpl.class);
    @Value(value="${http.callbackUrl}")
    private String callBackUrl;
    @Autowired
    private ApiClientFactory apiClientFactory;
    @Autowired
    private ResourcePersistenceService persistenceService;
    @Autowired
    private Config config;
    @Autowired
    private FileOperations fileOperations;

    @Override
    public ImportResult upload(SmartlingResourceUpdate resourceUpdate, File resource) throws ServiceException, SmartlingRestApiException {
        ImportResult result;
        Assert.notNull((Object)resourceUpdate, (String)"Update data must be provided");
        FilesApiClient smartlingFAPI = this.apiClientFactory.getFileApi(resourceUpdate.getRepositoryKey());
        String currentSmartlingFileUri = this.getCurrentSmartlingFileUriForUpload(resourceUpdate);
        if (ChangeType.DELETE.equals((Object)resourceUpdate.getChangeType())) {
            resourceUpdate.setSmartlingUri(currentSmartlingFileUri, null);
            result = this.deleteFile(smartlingFAPI, resourceUpdate);
        } else if (ChangeType.RENAME.equals((Object)resourceUpdate.getChangeType()) && null != this.persistenceService.findByRepositoryPath(resourceUpdate.getRepositoryKey(), resourceUpdate.getPreviousRepositoryPath())) {
            String newSmartlingFileUri = this.getSmartlingFileUriToRename(resourceUpdate, currentSmartlingFileUri);
            resourceUpdate.setSmartlingUri(currentSmartlingFileUri, newSmartlingFileUri);
            result = this.renameFile(smartlingFAPI, resourceUpdate);
        } else {
            Assert.notNull((Object)resource, (String)"Resource must be provided for upload");
            resourceUpdate.setSmartlingUri(null, currentSmartlingFileUri);
            result = this.uploadFile(smartlingFAPI, resourceUpdate, resource);
        }
        return result;
    }

    private String getSmartlingFileUriToRename(SmartlingResourceUpdate resourceUpdate, String currentSmartlingFileUri) {
        String newSmartlingUrl = RepoFileUtils.shortenerSmartlingUri(resourceUpdate.getRepositoryPrefix(), resourceUpdate.getRepositoryPath());
        if (resourceUpdate.getResourceType() == FileType.PDF) {
            return newSmartlingUrl + "." + FilenameUtils.getExtension(currentSmartlingFileUri);
        }
        return newSmartlingUrl;
    }

    private String getCurrentSmartlingFileUriForUpload(SmartlingResourceUpdate resourceUpdate) {
        String repositoryPath = ChangeType.DELETE.equals((Object)resourceUpdate.getChangeType()) || ChangeType.RENAME.equals((Object)resourceUpdate.getChangeType()) ? resourceUpdate.getPreviousRepositoryPath() : resourceUpdate.getRepositoryPath();
        ResourcePersistentData resourcePersistentData = this.persistenceService.findByRepositoryPath(resourceUpdate.getRepositoryKey(), repositoryPath);
        if (resourcePersistentData != null && !StringUtils.isEmpty(resourcePersistentData.getSmartlingUri())) {
            String smartlingFileUri = resourcePersistentData.getSmartlingUri();
            if (resourceUpdate.getResourceType() == FileType.PDF && ChangeType.MODIFY.equals((Object)resourceUpdate.getChangeType()) && !"pdf".equalsIgnoreCase(FilenameUtils.getExtension(smartlingFileUri))) {
                return FilenameUtils.removeExtension(smartlingFileUri);
            }
            return smartlingFileUri;
        }
        return RepoFileUtils.shortenerSmartlingUri(resourceUpdate.getRepositoryPrefix(), repositoryPath);
    }

    @Override
    public File download(VcsResourceUpdate resourceUpdate, String locale) throws ServiceException {
        Assert.notNull((Object)resourceUpdate, (String)"Translation download data must be provided");
        try {
            FilesApiClient smartlingFAPI = this.apiClientFactory.getFileApi(resourceUpdate.getRepositoryKey());
            FileLocaleStatusResponse fileStatusData = smartlingFAPI.getFileLocaleStatus(resourceUpdate.getSmartlingUri(), locale);
            int unauthorized = fileStatusData.getTotalStringCount() - fileStatusData.getAuthorizedStringCount() - fileStatusData.getCompletedStringCount() - fileStatusData.getExcludedStringCount();
            logger.info("File status total={}, authorized={}, unauthorized={}, completed={}, excluded={}, countUnauthorizedStrings={} for fileUri=\"{}\" and locale={}", new Object[]{fileStatusData.getTotalStringCount(), fileStatusData.getAuthorizedStringCount(), unauthorized, fileStatusData.getCompletedStringCount(), fileStatusData.getExcludedStringCount(), this.config.getBoolean("countUnauthorizedStrings"), resourceUpdate.getSmartlingUri(), locale});
            File contentBuffer = null;
            if (this.isDownloadIncomplete(resourceUpdate) || this.isApprovedStringsCompleted(fileStatusData)) {
                DownloadTranslationPTO parameters = DownloadTranslationPTO.builder().fileUri(this.getSmartlingFileUriForDownload(resourceUpdate)).retrievalType(resourceUpdate.getRetrievalType()).includeOriginalStrings(Boolean.valueOf(!resourceUpdate.isIncludeOriginalStrings())).build();
                InputStream response = smartlingFAPI.getFile(locale, parameters);
                contentBuffer = this.fileOperations.createFileBuffer(response);
            }
            return contentBuffer;
        }
        catch (SmartlingRestApiException e) {
            throw new ServiceException(String.format("Smartling download error fileUri='%s', locale='%s'", resourceUpdate.getSmartlingUri(), locale), e);
        }
    }

    private String getSmartlingFileUriForDownload(VcsResourceUpdate resourceUpdate) {
        if ("pdf".equalsIgnoreCase(FilenameUtils.getExtension(resourceUpdate.getSmartlingUri()))) {
            return resourceUpdate.getSmartlingUri() + ".docx";
        }
        return resourceUpdate.getSmartlingUri();
    }

    private boolean isDownloadIncomplete(VcsResourceUpdate resourceUpdate) {
        return resourceUpdate.isForce() || RetrievalTriggerType.ONCHANGE.equals((Object)resourceUpdate.getRetrievalTriggerType());
    }

    boolean isApprovedStringsCompleted(FileLocaleStatusResponse fileStatusData) {
        if (this.config.getBoolean("countUnauthorizedStrings")) {
            return fileStatusData.getCompletedStringCount() > 0 && fileStatusData.getTotalStringCount() - fileStatusData.getExcludedStringCount() == fileStatusData.getCompletedStringCount();
        }
        return fileStatusData.getCompletedStringCount() > 0 && fileStatusData.getAuthorizedStringCount() == 0;
    }

    @Override
    public List<String> getUpdatedLocales(ResourcePersistentData resource) throws ServiceException {
        Assert.notNull((Object)resource, (String)"Resource for lastModified must be provided");
        try {
            ArrayList<String> locales = new ArrayList<String>();
            FilesApiClient smartlingFAPI = this.apiClientFactory.getFileApi(resource.getRepositoryKey());
            GetFileLastModifiedPTO lastModifiedPTO = new GetFileLastModifiedPTO(resource.getSmartlingUri(), DateFormatter.format(resource.getLastModified()));
            List<FileLocaleLastModifiedPTO> lastModified = smartlingFAPI.getLastModified(lastModifiedPTO);
            for (FileLocaleLastModifiedPTO fileLocale : lastModified) {
                if (!ResourceUtils.isSupportsLocale(resource, fileLocale.getLocaleId())) continue;
                locales.add(fileLocale.getLocaleId());
            }
            return locales;
        }
        catch (SmartlingRestApiException e) {
            logger.error("Smartling last modified error fileUri='{}', statusCode={}, requestId={}", new Object[]{resource.getSmartlingUri(), e.getStatusCode(), e.getRequestId(), e});
            throw new ServiceException("Smartling download error", e);
        }
    }

    @Override
    public void checkProjectAccess(AuthenticationConfig authData) throws CredentialsInvalidException, SmartlingRestApiException {
        FilesApiClient fileApi = this.apiClientFactory.getFileApi(authData);
        fileApi.getFilesList(((GetFilesListPTO.GetFilesListPTOBuilder)((GetFilesListPTO.GetFilesListPTOBuilder)GetFilesListPTO.builder().limit(Integer.valueOf(1))).offset(Integer.valueOf(0))).build());
    }

    @Override
    public void checkSmartlingIsUp(AuthenticationConfig authData) throws CredentialsInvalidException {
        this.apiClientFactory.getLocalesApi(authData).getLocalesAsDictionary(null);
    }

    private ImportResult deleteFile(FilesApiClient smartlingFAPI, SmartlingResourceUpdate resourceUpdate) throws SmartlingRestApiException {
        logger.info("Resource {} is deleting from smartling...", (Object)resourceUpdate.getPreviousSmartlingUri());
        smartlingFAPI.deleteFile(resourceUpdate.getPreviousSmartlingUri());
        this.persistenceService.remove(resourceUpdate.getRepositoryKey(), resourceUpdate.getPreviousRepositoryPath());
        logger.info("Resource {} is deleted successfully", (Object)resourceUpdate.getPreviousSmartlingUri());
        return new ImportResult(ImportStatus.OK, resourceUpdate, null, ResourceStatus.DELETED);
    }

    private ImportResult renameFile(FilesApiClient smartlingFAPI, SmartlingResourceUpdate resourceUpdate) throws SmartlingRestApiException {
        logger.info("Resource {} is renaming to {} in smartling...", (Object)resourceUpdate.getPreviousSmartlingUri(), (Object)resourceUpdate.getSmartlingUri());
        RenameFilePto renameFilePto = RenameFilePto.builder().fileUri(resourceUpdate.getPreviousSmartlingUri()).newFileUri(resourceUpdate.getSmartlingUri()).build();
        smartlingFAPI.renameFile(renameFilePto);
        this.persistenceService.remove(resourceUpdate.getRepositoryKey(), resourceUpdate.getPreviousRepositoryPath());
        this.persistenceService.save(resourceUpdate);
        logger.info("Resource {} is renamed to {} successfully", (Object)resourceUpdate.getPreviousSmartlingUri(), (Object)resourceUpdate.getSmartlingUri());
        return new ImportResult(ImportStatus.OK, resourceUpdate, null, ResourceStatus.IN_PROGRESS);
    }

    private ImportResult uploadFile(FilesApiClient smartlingFAPI, SmartlingResourceUpdate resourceUpdate, File resource) throws SmartlingRestApiException {
        String callbackUrl = this.getCallbackUrl(resourceUpdate);
        logger.info("Resource {}, type {}, authorized {}, callback {} is uploading to smartling...", new Object[]{resourceUpdate.getSmartlingUri(), resourceUpdate.getResourceType(), resourceUpdate.getAuthorizeContent(), callbackUrl});
        UploadFilePTO.UploadFilePTOBuilder uploadFilePTOBuilder = UploadFilePTO.builder().fileType(resourceUpdate.getResourceType()).fileUri(resourceUpdate.getSmartlingUri()).directives(this.getDirectives(resourceUpdate)).callbackUrl(callbackUrl);
        if (resourceUpdate.getAuthorizeContent().booleanValue()) {
            uploadFilePTOBuilder.localeIdsToAuthorize(new ArrayList<String>(resourceUpdate.getLocalesMapping().keySet()));
        } else {
            uploadFilePTOBuilder.authorize(Boolean.valueOf(false));
        }
        uploadFilePTOBuilder.file(this.fileToInputStream(resource));
        UploadFileResponse uploadFileResponse = smartlingFAPI.uploadFile(uploadFilePTOBuilder.build());
        if (StringUtils.isNotEmpty(uploadFileResponse.getFileUri())) {
            resourceUpdate.setSmartlingUri(resourceUpdate.getSmartlingUri(), uploadFileResponse.getFileUri());
        }
        this.persistenceService.save(resourceUpdate);
        logger.info("Resource {} is uploaded successfully", (Object)resourceUpdate.getSmartlingUri());
        return new ImportResult(ImportStatus.OK, resourceUpdate, null, ResourceStatus.IN_PROGRESS);
    }

    private InputStream fileToInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("File %s can't be found", file.getAbsolutePath()));
        }
    }

    private String getCallbackUrl(SmartlingResourceUpdate resourceUpdate) {
        try {
            String callbackUrl = resourceUpdate.getResourceCallBackUrl();
            if (StringUtils.isBlank(callbackUrl) && StringUtils.isNotBlank(this.callBackUrl) && ResourceUtils.isSupportsDownload(resourceUpdate)) {
                callbackUrl = new URL(new URL(this.callBackUrl), "smartling").toString();
            }
            if (StringUtils.isBlank(callbackUrl)) {
                callbackUrl = null;
            }
            return callbackUrl;
        }
        catch (MalformedURLException e) {
            logger.error("Malformed Callback URL: '{}'", (Object)this.callBackUrl, (Object)e);
            throw new ConfigurationException("Malformed Callback URL - " + this.callBackUrl, e);
        }
    }

    private Map<String, String> getDirectives(SmartlingResourceUpdate resourceUpdate) {
        HashMap<String, String> directives = new HashMap<String, String>();
        if (null != resourceUpdate.getDirectives()) {
            directives.putAll(resourceUpdate.getDirectives());
        }
        if (resourceUpdate.getNamespace().booleanValue()) {
            directives.put(SMARTLING_NAMESPACE_DIRECTIVE, RepoFileUtils.shortenerSmartlingUri(resourceUpdate.getRepositoryAlias(), resourceUpdate.getRepositoryPath()));
        } else {
            directives.put(SMARTLING_FILE_URI_AS_NAMESPACE_DIRECTIVE, Boolean.FALSE.toString());
        }
        return directives;
    }
}

