/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.manager;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.services.AbstractService;
import com.smartling.repoconnector.services.CredentialsInvalidException;
import com.smartling.repoconnector.services.ServiceException;
import com.smartling.repoconnector.services.Startable;
import com.smartling.repoconnector.services.event.HealthEvent;
import com.smartling.repoconnector.services.http.HTTPListener;
import com.smartling.repoconnector.services.integration.uploader.SmartlingApiFacade;
import com.smartling.repoconnector.services.manager.SocketListener;
import com.smartling.repoconnector.services.queue.QueueProvider;
import com.smartling.repoconnector.services.vcs.RepositoryFactory;
import com.smartling.repoconnector.services.vcs.data.AuthenticationConfig;
import com.smartling.repoconnector.services.vcs.data.ProjectAuthenticationDataProvider;
import com.smartling.repoconnector.services.vcs.data.RepositoryDataProvider;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="brokerManager")
public class BrokerManager
extends AbstractService
implements Startable {
    private static final Logger logger = LoggerFactory.getLogger(BrokerManager.class);
    private static final String METRICS_DIR = "metrics";
    @Autowired
    private QueueProvider queue;
    @Autowired
    private HTTPListener http;
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired
    private RepositoryFactory repositoryFactory;
    @Autowired
    private RepositoryDataProvider repositoryDataProvider;
    @Autowired
    private SmartlingApiFacade smartlingApiFacade;
    @Autowired
    private ProjectAuthenticationDataProvider projectAuthProvider;
    private ScheduledReporter reporter;
    @Value(value="${manager.metricPeriod}")
    private Long period;
    @Value(value="${metrics_directory}")
    private String metricsDirectory;
    @Value(value="${manager.managePort}")
    private Integer managePort;
    private SocketListener socketListener;

    @PostConstruct
    public void init() {
        if (StringUtils.isBlank(this.metricsDirectory)) {
            this.metricsDirectory = FilenameUtils.concat(this.getConfigurationDirectory(), METRICS_DIR);
        }
        this.socketListener = new SocketListener(this);
    }

    @Override
    public void check() {
        this.queue.check();
        this.http.check();
    }

    public void validateStartup() {
        this.check();
        this.repositoryFactory.validateAllRepositories();
        Iterator<RepositoryKey> keys = this.repositoryDataProvider.getRepositoryKeys().iterator();
        if (keys.hasNext()) {
            RepositoryKey repositoryKey = keys.next();
            try {
                AuthenticationConfig authData = this.projectAuthProvider.getProjectAuthenticationData(repositoryKey);
                this.smartlingApiFacade.checkSmartlingIsUp(authData);
                this.fireEvent(new HealthEvent(this, this.getClass().getSimpleName()));
            }
            catch (RestApiRuntimeException | CredentialsInvalidException e) {
                logger.error("Error during check of Smartling status", e);
                this.fireEvent(new HealthEvent((Object)this, this.getClass().getSimpleName(), e.getMessage()));
            }
        } else {
            String message = "No repository keys are defined, cannot evaluate smartling connections";
            logger.error(message);
            this.fireEvent(new HealthEvent((Object)this, this.getClass().getSimpleName(), message));
        }
    }

    @Override
    public void start() throws ServiceException {
        logger.info("Repository Connector is starting");
        this.queue.start();
        this.http.start();
        this.reporter = this.setUpReporter();
        this.reporter.start(this.period.longValue(), TimeUnit.SECONDS);
        logger.info("Metrics reposter is started. Output dir: {}", (Object)this.metricsDirectory);
        this.socketListener.start();
        logger.info("Repository Connector successfully started");
    }

    @Override
    public void stop() throws ServiceException {
        logger.info("Repository Connector is stopping");
        this.socketListener.stopWorking();
        this.reporter.stop();
        this.http.stop();
        this.queue.stop();
        this.context.close();
        logger.info("Repository Connector successfully stopped");
    }

    public void schedule() throws ServiceException {
        this.repositoryFactory.scheduleAllRepositories();
        this.repositoryFactory.scheduleCleaningBranches();
    }

    protected ScheduledReporter setUpReporter() {
        MetricRegistry registry = this.getMetricRegistry();
        registry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet().getMetrics().get("total.used"));
        registry.register("jvm.descriptors", (Metric)new FileDescriptorRatioGauge());
        registry.register("jvm.threads.count", (Metric)new ThreadStatesGaugeSet().getMetrics().get("count"));
        File metricsDir = new File(this.metricsDirectory);
        if (!metricsDir.exists()) {
            metricsDir.mkdir();
        }
        return CsvReporter.forRegistry((MetricRegistry)registry).formatFor(Locale.US).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.SECONDS).build(metricsDir);
    }

    public Integer getManagePort() {
        return this.managePort;
    }
}

