/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.manager;

import com.smartling.repoconnector.services.manager.BrokerManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketListener
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(BrokerManager.class);
    private static final String LOCALHOST = "127.0.0.1";
    private final BrokerManager brokerManager;
    private ServerSocket manageSocket;
    private boolean working = true;

    SocketListener(BrokerManager brokerManager) {
        this.brokerManager = brokerManager;
    }

    public void stopWorking() {
        this.working = false;
        try {
            if (null != this.manageSocket) {
                this.manageSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.manageSocket = this.createServerSocket();
            while (this.working) {
                Socket socket = null;
                try {
                    socket = this.manageSocket.accept();
                    String command = IOUtils.toString(socket.getInputStream());
                    if (!"exit".equals(command.trim())) continue;
                    this.brokerManager.stop();
                }
                finally {
                    if (null == socket) continue;
                    socket.close();
                }
            }
        }
        catch (SocketException socket) {
        }
        catch (Exception e) {
            logger.error("SocketListener error!", (Throwable)e);
        }
        finally {
            if (null != this.manageSocket) {
                try {
                    this.manageSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ServerSocket createServerSocket() throws IOException {
        return new ServerSocket(this.brokerManager.getManagePort(), 50, InetAddress.getByName(LOCALHOST));
    }
}

