/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.repoconnector.services.persistence;

import com.smartling.repoconnector.model.RepositoryKey;
import com.smartling.repoconnector.services.persistence.dao.Dao;
import com.smartling.repoconnector.services.persistence.dto.RepositoryDTO;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPersistenceService {
    @Autowired
    private Dao dao;

    protected Dao getDao() {
        return this.dao;
    }

    protected RepositoryDTO findRepository(RepositoryKey repositoryKey) {
        return this.dao.searchSingle(RepositoryDTO.class, (root, cb) -> cb.createQuery(RepositoryDTO.class).where((Expression)cb.and(new Predicate[]{cb.equal((Expression)root.get("type"), (Object)repositoryKey.getType()), cb.equal((Expression)root.get("host"), (Object)repositoryKey.getHost()), cb.equal((Expression)root.get("path"), (Object)repositoryKey.getPath()), cb.equal((Expression)root.get("branch"), (Object)repositoryKey.getBranch())})));
    }

    protected RepositoryDTO findOrCreateRepository(RepositoryKey repositoryKey, String projectId) {
        RepositoryDTO repository = this.findRepository(repositoryKey);
        if (null == repository) {
            repository = new RepositoryDTO();
            repository.setType(repositoryKey.getType());
            repository.setProtocol(repositoryKey.getProtocol());
            repository.setHost(repositoryKey.getHost());
            repository.setPath(repositoryKey.getPath());
            repository.setBranch(repositoryKey.getBranch());
            repository.setProjectId(projectId);
            repository = this.dao.save(repository);
        }
        return repository;
    }
}

